/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.SerializableByteBufferMap;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.shaded.com.google.common.base.MoreObjects;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.shaded.org.apache.avro.specific.SpecificData;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;

class GenericDataFile
implements DataFile,
IndexedRecord,
StructLike,
SpecificData.SchemaConstructable,
Serializable {
    private static final Types.StructType EMPTY_STRUCT_TYPE = Types.StructType.of(new Types.NestedField[0]);
    private static final PartitionData EMPTY_PARTITION_DATA = new PartitionData(EMPTY_STRUCT_TYPE){

        @Override
        public PartitionData copy() {
            return this;
        }
    };
    private int[] fromProjectionPos;
    private Types.StructType partitionType;
    private String filePath = null;
    private FileFormat format = null;
    private PartitionData partitionData = null;
    private Long recordCount = null;
    private long fileSizeInBytes = -1L;
    private Integer fileOrdinal = null;
    private List<Integer> sortColumns = null;
    private Map<Integer, Long> columnSizes = null;
    private Map<Integer, Long> valueCounts = null;
    private Map<Integer, Long> nullValueCounts = null;
    private Map<Integer, ByteBuffer> lowerBounds = null;
    private Map<Integer, ByteBuffer> upperBounds = null;
    private List<Long> splitOffsets = null;
    private byte[] keyMetadata = null;
    private transient Schema avroSchema = null;
    private static final long DEFAULT_BLOCK_SIZE = 0x4000000L;

    public GenericDataFile(Schema avroSchema) {
        this.avroSchema = avroSchema;
        Types.StructType schema = AvroSchemaUtil.convert(avroSchema).asNestedType().asStructType();
        Type partType = schema.fieldType("partition");
        this.partitionType = partType != null ? partType.asNestedType().asStructType() : EMPTY_STRUCT_TYPE;
        List<Types.NestedField> fields = schema.fields();
        List<Types.NestedField> allFields = DataFile.getType(this.partitionType).fields();
        this.fromProjectionPos = new int[fields.size()];
        for (int i = 0; i < this.fromProjectionPos.length; ++i) {
            boolean found = false;
            for (int j = 0; j < allFields.size(); ++j) {
                if (fields.get(i).fieldId() != allFields.get(j).fieldId()) continue;
                found = true;
                this.fromProjectionPos[i] = j;
            }
            if (found) continue;
            throw new IllegalArgumentException("Cannot find projected field: " + fields.get(i));
        }
        this.partitionData = new PartitionData(this.partitionType);
    }

    GenericDataFile(String filePath, FileFormat format, long recordCount, long fileSizeInBytes) {
        this.filePath = filePath;
        this.format = format;
        this.partitionData = EMPTY_PARTITION_DATA;
        this.partitionType = EMPTY_PARTITION_DATA.getPartitionType();
        this.recordCount = recordCount;
        this.fileSizeInBytes = fileSizeInBytes;
    }

    GenericDataFile(String filePath, FileFormat format, PartitionData partition, long recordCount, long fileSizeInBytes) {
        this.filePath = filePath;
        this.format = format;
        this.partitionData = partition;
        this.partitionType = partition.getPartitionType();
        this.recordCount = recordCount;
        this.fileSizeInBytes = fileSizeInBytes;
    }

    GenericDataFile(String filePath, FileFormat format, PartitionData partition, long fileSizeInBytes, Metrics metrics, List<Long> splitOffsets) {
        this.filePath = filePath;
        this.format = format;
        if (partition == null) {
            this.partitionData = EMPTY_PARTITION_DATA;
            this.partitionType = EMPTY_PARTITION_DATA.getPartitionType();
        } else {
            this.partitionData = partition;
            this.partitionType = partition.getPartitionType();
        }
        this.recordCount = metrics.recordCount();
        this.fileSizeInBytes = fileSizeInBytes;
        this.columnSizes = metrics.columnSizes();
        this.valueCounts = metrics.valueCounts();
        this.nullValueCounts = metrics.nullValueCounts();
        this.lowerBounds = SerializableByteBufferMap.wrap(metrics.lowerBounds());
        this.upperBounds = SerializableByteBufferMap.wrap(metrics.upperBounds());
        this.splitOffsets = GenericDataFile.copy(splitOffsets);
    }

    GenericDataFile(String filePath, FileFormat format, PartitionData partition, long fileSizeInBytes, Metrics metrics, ByteBuffer keyMetadata, List<Long> splitOffsets) {
        this(filePath, format, partition, fileSizeInBytes, metrics, splitOffsets);
        this.keyMetadata = ByteBuffers.toByteArray(keyMetadata);
    }

    private GenericDataFile(GenericDataFile toCopy, boolean fullCopy) {
        this.filePath = toCopy.filePath;
        this.format = toCopy.format;
        this.partitionData = toCopy.partitionData.copy();
        this.partitionType = toCopy.partitionType;
        this.recordCount = toCopy.recordCount;
        this.fileSizeInBytes = toCopy.fileSizeInBytes;
        this.fileOrdinal = toCopy.fileOrdinal;
        this.sortColumns = GenericDataFile.copy(toCopy.sortColumns);
        if (fullCopy) {
            this.columnSizes = GenericDataFile.copy(toCopy.columnSizes);
            this.valueCounts = GenericDataFile.copy(toCopy.valueCounts);
            this.nullValueCounts = GenericDataFile.copy(toCopy.nullValueCounts);
            this.lowerBounds = SerializableByteBufferMap.wrap(GenericDataFile.copy(toCopy.lowerBounds));
            this.upperBounds = SerializableByteBufferMap.wrap(GenericDataFile.copy(toCopy.upperBounds));
        } else {
            this.columnSizes = null;
            this.valueCounts = null;
            this.nullValueCounts = null;
            this.lowerBounds = null;
            this.upperBounds = null;
        }
        this.fromProjectionPos = toCopy.fromProjectionPos;
        this.keyMetadata = toCopy.keyMetadata == null ? null : Arrays.copyOf(toCopy.keyMetadata, toCopy.keyMetadata.length);
        this.splitOffsets = GenericDataFile.copy(toCopy.splitOffsets);
    }

    GenericDataFile() {
    }

    @Override
    public CharSequence path() {
        return this.filePath;
    }

    @Override
    public FileFormat format() {
        return this.format;
    }

    @Override
    public StructLike partition() {
        return this.partitionData;
    }

    @Override
    public long recordCount() {
        return this.recordCount;
    }

    @Override
    public long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    @Override
    public Integer fileOrdinal() {
        return this.fileOrdinal;
    }

    @Override
    public List<Integer> sortColumns() {
        return this.sortColumns;
    }

    @Override
    public Map<Integer, Long> columnSizes() {
        return this.columnSizes;
    }

    @Override
    public Map<Integer, Long> valueCounts() {
        return this.valueCounts;
    }

    @Override
    public Map<Integer, Long> nullValueCounts() {
        return this.nullValueCounts;
    }

    @Override
    public Map<Integer, ByteBuffer> lowerBounds() {
        return this.lowerBounds;
    }

    @Override
    public Map<Integer, ByteBuffer> upperBounds() {
        return this.upperBounds;
    }

    @Override
    public ByteBuffer keyMetadata() {
        return this.keyMetadata != null ? ByteBuffer.wrap(this.keyMetadata) : null;
    }

    @Override
    public List<Long> splitOffsets() {
        return this.splitOffsets;
    }

    @Override
    public Schema getSchema() {
        if (this.avroSchema == null) {
            this.avroSchema = GenericDataFile.getAvroSchema(this.partitionType);
        }
        return this.avroSchema;
    }

    @Override
    public void put(int i, Object v) {
        int pos = i;
        if (this.fromProjectionPos != null) {
            pos = this.fromProjectionPos[i];
        }
        switch (pos) {
            case 0: {
                this.filePath = v.toString();
                return;
            }
            case 1: {
                this.format = FileFormat.valueOf(v.toString());
                return;
            }
            case 2: {
                this.partitionData = (PartitionData)v;
                return;
            }
            case 3: {
                this.recordCount = (Long)v;
                return;
            }
            case 4: {
                this.fileSizeInBytes = (Long)v;
                return;
            }
            case 5: {
                return;
            }
            case 6: {
                this.fileOrdinal = (Integer)v;
                return;
            }
            case 7: {
                this.sortColumns = (List)v;
                return;
            }
            case 8: {
                this.columnSizes = (Map)v;
                return;
            }
            case 9: {
                this.valueCounts = (Map)v;
                return;
            }
            case 10: {
                this.nullValueCounts = (Map)v;
                return;
            }
            case 11: {
                this.lowerBounds = SerializableByteBufferMap.wrap((Map)v);
                return;
            }
            case 12: {
                this.upperBounds = SerializableByteBufferMap.wrap((Map)v);
                return;
            }
            case 13: {
                this.keyMetadata = ByteBuffers.toByteArray((ByteBuffer)v);
                return;
            }
            case 14: {
                this.splitOffsets = (List)v;
                return;
            }
        }
    }

    @Override
    public <T> void set(int pos, T value) {
        this.put(pos, value);
    }

    @Override
    public Object get(int i) {
        int pos = i;
        if (this.fromProjectionPos != null) {
            pos = this.fromProjectionPos[i];
        }
        switch (pos) {
            case 0: {
                return this.filePath;
            }
            case 1: {
                return this.format != null ? this.format.toString() : null;
            }
            case 2: {
                return this.partitionData;
            }
            case 3: {
                return this.recordCount;
            }
            case 4: {
                return this.fileSizeInBytes;
            }
            case 5: {
                return 0x4000000L;
            }
            case 6: {
                return this.fileOrdinal;
            }
            case 7: {
                return this.sortColumns;
            }
            case 8: {
                return this.columnSizes;
            }
            case 9: {
                return this.valueCounts;
            }
            case 10: {
                return this.nullValueCounts;
            }
            case 11: {
                return this.lowerBounds;
            }
            case 12: {
                return this.upperBounds;
            }
            case 13: {
                return this.keyMetadata;
            }
            case 14: {
                return this.splitOffsets;
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + pos);
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        return javaClass.cast(this.get(pos));
    }

    private static Schema getAvroSchema(Types.StructType partitionType) {
        Types.StructType type = DataFile.getType(partitionType);
        return AvroSchemaUtil.convert((Type)type, ImmutableMap.of(type, GenericDataFile.class.getName(), partitionType, PartitionData.class.getName()));
    }

    @Override
    public int size() {
        return 15;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("file_path", this.filePath).add("file_format", (Object)this.format).add("partition", this.partitionData).add("record_count", this.recordCount).add("file_size_in_bytes", this.fileSizeInBytes).add("column_sizes", this.columnSizes).add("value_counts", this.valueCounts).add("null_value_counts", this.nullValueCounts).add("lower_bounds", this.lowerBounds).add("upper_bounds", this.upperBounds).add("key_metadata", this.keyMetadata == null ? "null" : "(redacted)").add("split_offsets", this.splitOffsets == null ? "null" : this.splitOffsets).toString();
    }

    @Override
    public DataFile copyWithoutStats() {
        return new GenericDataFile(this, false);
    }

    @Override
    public DataFile copy() {
        return new GenericDataFile(this, true);
    }

    private static <K, V> Map<K, V> copy(Map<K, V> map) {
        if (map != null) {
            HashMap<K, V> copy = Maps.newHashMapWithExpectedSize(map.size());
            copy.putAll(map);
            return Collections.unmodifiableMap(copy);
        }
        return null;
    }

    private static <E> List<E> copy(List<E> list) {
        if (list != null) {
            ArrayList<E> copy = Lists.newArrayListWithExpectedSize(list.size());
            copy.addAll(list);
            return Collections.unmodifiableList(copy);
        }
        return null;
    }
}

