/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.List;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.shaded.com.google.common.base.MoreObjects;
import org.apache.iceberg.shaded.com.google.common.base.Objects;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.shaded.com.google.common.collect.Iterables;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.shaded.org.apache.avro.specific.SpecificData;
import org.apache.iceberg.types.Types;

public class GenericManifestFile
implements ManifestFile,
StructLike,
IndexedRecord,
SpecificData.SchemaConstructable,
Serializable {
    private static final Schema AVRO_SCHEMA = AvroSchemaUtil.convert(ManifestFile.schema(), "manifest_file");
    private transient Schema avroSchema;
    private int[] fromProjectionPos;
    private InputFile file = null;
    private String manifestPath = null;
    private Long length = null;
    private int specId = -1;
    private Long snapshotId = null;
    private Integer addedFilesCount = null;
    private Integer existingFilesCount = null;
    private Integer deletedFilesCount = null;
    private List<ManifestFile.PartitionFieldSummary> partitions = null;

    public GenericManifestFile(Schema avroSchema) {
        this.avroSchema = avroSchema;
        List<Types.NestedField> fields = AvroSchemaUtil.convert(avroSchema).asNestedType().asStructType().fields();
        List<Types.NestedField> allFields = ManifestFile.schema().asStruct().fields();
        this.fromProjectionPos = new int[fields.size()];
        for (int i = 0; i < this.fromProjectionPos.length; ++i) {
            boolean found = false;
            for (int j = 0; j < allFields.size(); ++j) {
                if (fields.get(i).fieldId() != allFields.get(j).fieldId()) continue;
                found = true;
                this.fromProjectionPos[i] = j;
            }
            if (found) continue;
            throw new IllegalArgumentException("Cannot find projected field: " + fields.get(i));
        }
    }

    GenericManifestFile(InputFile file, int specId) {
        this.avroSchema = AVRO_SCHEMA;
        this.file = file;
        this.manifestPath = file.location();
        this.length = null;
        this.specId = specId;
        this.snapshotId = null;
        this.addedFilesCount = null;
        this.existingFilesCount = null;
        this.deletedFilesCount = null;
        this.partitions = null;
        this.fromProjectionPos = null;
    }

    public GenericManifestFile(String path, long length, int specId, long snapshotId, int addedFilesCount, int existingFilesCount, int deletedFilesCount, List<ManifestFile.PartitionFieldSummary> partitions) {
        this.avroSchema = AVRO_SCHEMA;
        this.manifestPath = path;
        this.length = length;
        this.specId = specId;
        this.snapshotId = snapshotId;
        this.addedFilesCount = addedFilesCount;
        this.existingFilesCount = existingFilesCount;
        this.deletedFilesCount = deletedFilesCount;
        this.partitions = partitions;
        this.fromProjectionPos = null;
    }

    private GenericManifestFile(GenericManifestFile toCopy) {
        this.avroSchema = toCopy.avroSchema;
        this.manifestPath = toCopy.manifestPath;
        this.length = toCopy.length;
        this.specId = toCopy.specId;
        this.snapshotId = toCopy.snapshotId;
        this.addedFilesCount = toCopy.addedFilesCount;
        this.existingFilesCount = toCopy.existingFilesCount;
        this.deletedFilesCount = toCopy.deletedFilesCount;
        this.partitions = ImmutableList.copyOf(Iterables.transform(toCopy.partitions, ManifestFile.PartitionFieldSummary::copy));
        this.fromProjectionPos = toCopy.fromProjectionPos;
    }

    GenericManifestFile() {
    }

    @Override
    public String path() {
        return this.manifestPath;
    }

    public Long lazyLength() {
        if (this.length == null) {
            if (this.file != null) {
                this.length = this.file.getLength();
            } else {
                return null;
            }
        }
        return this.length;
    }

    @Override
    public long length() {
        return this.lazyLength();
    }

    @Override
    public int partitionSpecId() {
        return this.specId;
    }

    @Override
    public Long snapshotId() {
        return this.snapshotId;
    }

    @Override
    public Integer addedFilesCount() {
        return this.addedFilesCount;
    }

    @Override
    public Integer existingFilesCount() {
        return this.existingFilesCount;
    }

    @Override
    public Integer deletedFilesCount() {
        return this.deletedFilesCount;
    }

    @Override
    public List<ManifestFile.PartitionFieldSummary> partitions() {
        return this.partitions;
    }

    @Override
    public int size() {
        return ManifestFile.schema().columns().size();
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        return javaClass.cast(this.get(pos));
    }

    @Override
    public Object get(int i) {
        int pos = i;
        if (this.fromProjectionPos != null) {
            pos = this.fromProjectionPos[i];
        }
        switch (pos) {
            case 0: {
                return this.manifestPath;
            }
            case 1: {
                return this.lazyLength();
            }
            case 2: {
                return this.specId;
            }
            case 3: {
                return this.snapshotId;
            }
            case 4: {
                return this.addedFilesCount;
            }
            case 5: {
                return this.existingFilesCount;
            }
            case 6: {
                return this.deletedFilesCount;
            }
            case 7: {
                return this.partitions;
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + pos);
    }

    @Override
    public <T> void set(int i, T value) {
        int pos = i;
        if (this.fromProjectionPos != null) {
            pos = this.fromProjectionPos[i];
        }
        switch (pos) {
            case 0: {
                this.manifestPath = value.toString();
                return;
            }
            case 1: {
                this.length = (Long)value;
                return;
            }
            case 2: {
                this.specId = (Integer)value;
                return;
            }
            case 3: {
                this.snapshotId = (Long)value;
                return;
            }
            case 4: {
                this.addedFilesCount = (Integer)value;
                return;
            }
            case 5: {
                this.existingFilesCount = (Integer)value;
                return;
            }
            case 6: {
                this.deletedFilesCount = (Integer)value;
                return;
            }
            case 7: {
                this.partitions = (List)value;
                return;
            }
        }
    }

    @Override
    public void put(int i, Object v) {
        this.set(i, v);
    }

    @Override
    public ManifestFile copy() {
        return new GenericManifestFile(this);
    }

    @Override
    public Schema getSchema() {
        return this.avroSchema;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GenericManifestFile that = (GenericManifestFile)other;
        return Objects.equal(this.manifestPath, that.manifestPath);
    }

    public int hashCode() {
        return Objects.hashCode(this.manifestPath);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("path", this.manifestPath).add("length", this.length).add("partition_spec_id", this.specId).add("added_snapshot_id", this.snapshotId).add("added_data_files_count", this.addedFilesCount).add("existing_data_files_count", this.existingFilesCount).add("deleted_data_files_count", this.deletedFilesCount).add("partitions", this.partitions).toString();
    }
}

