/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Function;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.shaded.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SnapshotUtil;

public class HistoryTable
extends BaseMetadataTable {
    private static final Schema HISTORY_SCHEMA = new Schema(Types.NestedField.required(1, "made_current_at", Types.TimestampType.withZone()), Types.NestedField.required(2, "snapshot_id", Types.LongType.get()), Types.NestedField.optional(3, "parent_id", Types.LongType.get()), Types.NestedField.required(4, "is_current_ancestor", Types.BooleanType.get()));
    private final TableOperations ops;
    private final Table table;

    public HistoryTable(TableOperations ops, Table table) {
        this.ops = ops;
        this.table = table;
    }

    @Override
    Table table() {
        return this.table;
    }

    @Override
    String metadataTableName() {
        return "history";
    }

    @Override
    public TableScan newScan() {
        return new HistoryScan();
    }

    @Override
    public String location() {
        return this.ops.current().file().location();
    }

    @Override
    public Schema schema() {
        return HISTORY_SCHEMA;
    }

    private DataTask task(TableScan scan) {
        return StaticDataTask.of(this.ops.current().file(), this.ops.current().snapshotLog(), HistoryTable.convertHistoryEntryFunc(this.table));
    }

    private static Function<HistoryEntry, StaticDataTask.Row> convertHistoryEntryFunc(Table table) {
        HashMap<Long, Snapshot> snapshots = Maps.newHashMap();
        for (Snapshot snap : table.snapshots()) {
            snapshots.put(snap.snapshotId(), snap);
        }
        HashSet<Long> ancestorIds = Sets.newHashSet(SnapshotUtil.currentAncestors(table));
        return historyEntry -> {
            long snapshotId = historyEntry.snapshotId();
            Snapshot snap = (Snapshot)snapshots.get(snapshotId);
            return StaticDataTask.Row.of(historyEntry.timestampMillis() * 1000L, historyEntry.snapshotId(), snap != null ? snap.parentId() : null, ancestorIds.contains(snapshotId));
        };
    }

    private class HistoryScan
    extends StaticTableScan {
        HistoryScan() {
            super(HistoryTable.this.ops, HistoryTable.this.table, HISTORY_SCHEMA, x$0 -> HistoryTable.this.task(x$0));
        }
    }
}

