/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;

public class LocationProviders {
    private LocationProviders() {
    }

    public static LocationProvider locationsFor(String location, Map<String, String> properties) {
        if (PropertyUtil.propertyAsBoolean(properties, "write.object-storage.enabled", false)) {
            return new ObjectStoreLocationProvider(location, properties);
        }
        return new DefaultLocationProvider(location, properties);
    }

    private static String stripTrailingSlash(String path) {
        String result = path;
        while (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    static class ObjectStoreLocationProvider
    implements LocationProvider {
        private static final Transform<String, Integer> HASH_FUNC = Transforms.bucket(Types.StringType.get(), Integer.MAX_VALUE);
        private final String storageLocation;
        private final String context;

        ObjectStoreLocationProvider(String tableLocation, Map<String, String> properties) {
            this.storageLocation = LocationProviders.stripTrailingSlash(properties.get("write.object-storage.path"));
            this.context = ObjectStoreLocationProvider.pathContext(tableLocation);
        }

        @Override
        public String newDataLocation(PartitionSpec spec, StructLike partitionData, String filename) {
            return this.newDataLocation(String.format("%s/%s", spec.partitionToPath(partitionData), filename));
        }

        @Override
        public String newDataLocation(String filename) {
            int hash = HASH_FUNC.apply(filename);
            return String.format("%s/%08x/%s/%s", this.storageLocation, hash, this.context, filename);
        }

        private static String pathContext(String tableLocation) {
            Path dataPath = new Path(tableLocation);
            Path parent = dataPath.getParent();
            String resolvedContext = parent != null ? String.format("%s/%s", parent.getName(), dataPath.getName()) : dataPath.getName();
            Preconditions.checkState(!resolvedContext.endsWith("/"), "Path context must not end with a slash.");
            return resolvedContext;
        }
    }

    static class DefaultLocationProvider
    implements LocationProvider {
        private final String dataLocation;

        DefaultLocationProvider(String tableLocation, Map<String, String> properties) {
            this.dataLocation = LocationProviders.stripTrailingSlash(properties.getOrDefault("write.folder-storage.path", String.format("%s/data", tableLocation)));
        }

        @Override
        public String newDataLocation(PartitionSpec spec, StructLike partitionData, String filename) {
            return String.format("%s/%s/%s", this.dataLocation, spec.partitionToPath(partitionData), filename);
        }

        @Override
        public String newDataLocation(String filename) {
            return String.format("%s/%s", this.dataLocation, filename);
        }
    }
}

