/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Collection;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.shaded.com.google.common.base.MoreObjects;
import org.apache.iceberg.shaded.org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.shaded.org.apache.avro.specific.SpecificData;
import org.apache.iceberg.types.Types;

class ManifestEntry
implements IndexedRecord,
SpecificData.SchemaConstructable {
    private final org.apache.iceberg.shaded.org.apache.avro.Schema schema;
    private Status status = Status.EXISTING;
    private long snapshotId = 0L;
    private DataFile file = null;

    ManifestEntry(org.apache.iceberg.shaded.org.apache.avro.Schema schema) {
        this.schema = schema;
    }

    ManifestEntry(Types.StructType partitionType) {
        this.schema = AvroSchemaUtil.convert(ManifestEntry.getSchema(partitionType), "manifest_entry");
    }

    private ManifestEntry(ManifestEntry toCopy, boolean fullCopy) {
        this.schema = toCopy.schema;
        this.status = toCopy.status;
        this.snapshotId = toCopy.snapshotId;
        this.file = fullCopy ? toCopy.file().copy() : toCopy.file().copyWithoutStats();
    }

    ManifestEntry wrapExisting(long newSnapshotId, DataFile newFile) {
        this.status = Status.EXISTING;
        this.snapshotId = newSnapshotId;
        this.file = newFile;
        return this;
    }

    ManifestEntry wrapAppend(long newSnapshotId, DataFile newFile) {
        this.status = Status.ADDED;
        this.snapshotId = newSnapshotId;
        this.file = newFile;
        return this;
    }

    ManifestEntry wrapDelete(long newSnapshotId, DataFile newFile) {
        this.status = Status.DELETED;
        this.snapshotId = newSnapshotId;
        this.file = newFile;
        return this;
    }

    public Status status() {
        return this.status;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public DataFile file() {
        return this.file;
    }

    public ManifestEntry copy() {
        return new ManifestEntry(this, true);
    }

    public ManifestEntry copyWithoutStats() {
        return new ManifestEntry(this, false);
    }

    @Override
    public void put(int i, Object v) {
        switch (i) {
            case 0: {
                this.status = Status.values()[(Integer)v];
                return;
            }
            case 1: {
                this.snapshotId = (Long)v;
                return;
            }
            case 2: {
                this.file = (DataFile)v;
                return;
            }
        }
    }

    @Override
    public Object get(int i) {
        switch (i) {
            case 0: {
                return this.status.id();
            }
            case 1: {
                return this.snapshotId;
            }
            case 2: {
                return this.file;
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + i);
    }

    @Override
    public org.apache.iceberg.shaded.org.apache.avro.Schema getSchema() {
        return this.schema;
    }

    static Schema getSchema(Types.StructType partitionType) {
        return ManifestEntry.wrapFileSchema(DataFile.getType(partitionType));
    }

    static Schema projectSchema(Types.StructType partitionType, Collection<String> columns) {
        return ManifestEntry.wrapFileSchema(new Schema(DataFile.getType(partitionType).fields()).select(columns).asStruct());
    }

    static Schema wrapFileSchema(Types.StructType fileStruct) {
        return new Schema(Types.NestedField.required(0, "status", Types.IntegerType.get()), Types.NestedField.required(1, "snapshot_id", Types.LongType.get()), Types.NestedField.required(2, "data_file", fileStruct));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("status", (Object)this.status).add("snapshot_id", this.snapshotId).add("file", this.file).toString();
    }

    static enum Status {
        EXISTING(0),
        ADDED(1),
        DELETED(2);

        private final int id;

        private Status(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

