/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Filterable;
import org.apache.iceberg.FilteredManifest;
import org.apache.iceberg.GenericDataFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.shaded.com.google.common.collect.Iterables;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;

class ManifestGroup {
    private static final Types.StructType EMPTY_STRUCT = Types.StructType.of(new Types.NestedField[0]);
    private final TableOperations ops;
    private final Set<ManifestFile> manifests;
    private final Expression dataFilter;
    private final Expression fileFilter;
    private final Expression partitionFilter;
    private final boolean ignoreDeleted;
    private final boolean ignoreExisting;
    private final List<String> columns;
    private final boolean caseSensitive;
    private final LoadingCache<Integer, ManifestEvaluator> evalCache;

    ManifestGroup(TableOperations ops, Iterable<ManifestFile> manifests) {
        this(ops, Sets.newHashSet(manifests), Expressions.alwaysTrue(), Expressions.alwaysTrue(), Expressions.alwaysTrue(), false, false, ImmutableList.of("*"), true);
    }

    private ManifestGroup(TableOperations ops, Set<ManifestFile> manifests, Expression dataFilter, Expression fileFilter, Expression partitionFilter, boolean ignoreDeleted, boolean ignoreExisting, List<String> columns, boolean caseSensitive) {
        this.ops = ops;
        this.manifests = manifests;
        this.dataFilter = dataFilter;
        this.fileFilter = fileFilter;
        this.partitionFilter = partitionFilter;
        this.ignoreDeleted = ignoreDeleted;
        this.ignoreExisting = ignoreExisting;
        this.columns = columns;
        this.caseSensitive = caseSensitive;
        this.evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = ops.current().spec((int)specId);
            return ManifestEvaluator.forPartitionFilter(Expressions.and(partitionFilter, Projections.inclusive(spec).project(dataFilter)), spec, caseSensitive);
        });
    }

    public ManifestGroup caseSensitive(boolean filterCaseSensitive) {
        return new ManifestGroup(this.ops, this.manifests, this.dataFilter, this.fileFilter, this.partitionFilter, this.ignoreDeleted, this.ignoreExisting, this.columns, filterCaseSensitive);
    }

    public ManifestGroup filterData(Expression expr) {
        return new ManifestGroup(this.ops, this.manifests, Expressions.and(this.dataFilter, expr), this.fileFilter, this.partitionFilter, this.ignoreDeleted, this.ignoreExisting, this.columns, this.caseSensitive);
    }

    public ManifestGroup filterFiles(Expression expr) {
        return new ManifestGroup(this.ops, this.manifests, this.dataFilter, Expressions.and(this.fileFilter, expr), this.partitionFilter, this.ignoreDeleted, this.ignoreExisting, this.columns, this.caseSensitive);
    }

    public ManifestGroup filterPartitions(Expression expr) {
        return new ManifestGroup(this.ops, this.manifests, this.dataFilter, this.fileFilter, Expressions.and(this.partitionFilter, expr), this.ignoreDeleted, this.ignoreExisting, this.columns, this.caseSensitive);
    }

    public ManifestGroup ignoreDeleted() {
        return new ManifestGroup(this.ops, this.manifests, this.dataFilter, this.fileFilter, this.partitionFilter, true, this.ignoreExisting, this.columns, this.caseSensitive);
    }

    public ManifestGroup ignoreDeleted(boolean shouldIgnoreDeleted) {
        return new ManifestGroup(this.ops, this.manifests, this.dataFilter, this.fileFilter, this.partitionFilter, shouldIgnoreDeleted, this.ignoreExisting, this.columns, this.caseSensitive);
    }

    public ManifestGroup ignoreExisting() {
        return new ManifestGroup(this.ops, this.manifests, this.dataFilter, this.fileFilter, this.partitionFilter, this.ignoreDeleted, true, this.columns, this.caseSensitive);
    }

    public ManifestGroup ignoreExisting(boolean shouldIgnoreExisting) {
        return new ManifestGroup(this.ops, this.manifests, this.dataFilter, this.fileFilter, this.partitionFilter, this.ignoreDeleted, shouldIgnoreExisting, this.columns, this.caseSensitive);
    }

    public ManifestGroup select(List<String> columnNames) {
        return new ManifestGroup(this.ops, this.manifests, this.dataFilter, this.fileFilter, this.partitionFilter, this.ignoreDeleted, this.ignoreExisting, Lists.newArrayList(columnNames), this.caseSensitive);
    }

    public ManifestGroup select(String ... columnNames) {
        return this.select(Arrays.asList(columnNames));
    }

    public CloseableIterable<ManifestEntry> entries() {
        Evaluator evaluator = new Evaluator(DataFile.getType(EMPTY_STRUCT), this.fileFilter, this.caseSensitive);
        Iterable<ManifestFile> matchingManifests = Iterables.filter(this.manifests, manifest -> this.evalCache.get(manifest.partitionSpecId()).eval((ManifestFile)manifest));
        if (this.ignoreDeleted) {
            matchingManifests = Iterables.filter(matchingManifests, manifest -> manifest.hasAddedFiles() || manifest.hasExistingFiles());
        }
        if (this.ignoreExisting) {
            matchingManifests = Iterables.filter(matchingManifests, manifest -> manifest.hasAddedFiles() || manifest.hasDeletedFiles());
        }
        Iterable readers = Iterables.transform(matchingManifests, manifest -> {
            ManifestReader reader = ManifestReader.read(this.ops.io().newInputFile(manifest.path()), this.ops.current()::spec);
            Filterable filtered = reader.filterRows(this.dataFilter).filterPartitions(this.partitionFilter).select(this.columns);
            CloseableIterable<ManifestEntry> entries = ((FilteredManifest)filtered).allEntries();
            if (this.ignoreDeleted) {
                entries = ((FilteredManifest)filtered).liveEntries();
            }
            if (this.ignoreExisting) {
                entries = CloseableIterable.filter(entries, entry -> entry.status() != ManifestEntry.Status.EXISTING);
            }
            if (this.fileFilter != null && this.fileFilter != Expressions.alwaysTrue()) {
                entries = CloseableIterable.filter(entries, entry -> evaluator.eval((GenericDataFile)entry.file()));
            }
            return entries;
        });
        return CloseableIterable.concat(readers);
    }
}

