/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableMap;

class ManifestListWriter
implements FileAppender<ManifestFile> {
    private final FileAppender<ManifestFile> writer;

    ManifestListWriter(OutputFile snapshotFile, long snapshotId, Long parentSnapshotId) {
        this.writer = ManifestListWriter.newAppender(snapshotFile, ImmutableMap.of("snapshot-id", String.valueOf(snapshotId), "parent-snapshot-id", String.valueOf(parentSnapshotId)));
    }

    @Override
    public void add(ManifestFile file) {
        this.writer.add(file);
    }

    @Override
    public void addAll(Iterator<ManifestFile> values) {
        this.writer.addAll(values);
    }

    @Override
    public void addAll(Iterable<ManifestFile> values) {
        this.writer.addAll(values);
    }

    @Override
    public Metrics metrics() {
        return this.writer.metrics();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public long length() {
        return this.writer.length();
    }

    private static FileAppender<ManifestFile> newAppender(OutputFile file, Map<String, String> meta) {
        try {
            return Avro.write(file).schema(ManifestFile.schema()).named("manifest_file").meta(meta).overwrite().build();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to create snapshot list writer for path: " + file, new Object[0]);
        }
    }
}

