/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Types;

public class ManifestsTable
extends BaseMetadataTable {
    private static final Schema SNAPSHOT_SCHEMA = new Schema(Types.NestedField.required(1, "path", Types.StringType.get()), Types.NestedField.required(2, "length", Types.LongType.get()), Types.NestedField.required(3, "partition_spec_id", Types.IntegerType.get()), Types.NestedField.required(4, "added_snapshot_id", Types.LongType.get()), Types.NestedField.required(5, "added_data_files_count", Types.IntegerType.get()), Types.NestedField.required(6, "existing_data_files_count", Types.IntegerType.get()), Types.NestedField.required(7, "deleted_data_files_count", Types.IntegerType.get()), Types.NestedField.required(8, "partition_summaries", Types.ListType.ofRequired(9, Types.StructType.of(Types.NestedField.required(10, "contains_null", Types.BooleanType.get()), Types.NestedField.optional(11, "lower_bound", Types.StringType.get()), Types.NestedField.optional(12, "upper_bound", Types.StringType.get())))));
    private final TableOperations ops;
    private final Table table;
    private final PartitionSpec spec;

    public ManifestsTable(TableOperations ops, Table table) {
        this.ops = ops;
        this.table = table;
        this.spec = table.spec();
    }

    @Override
    Table table() {
        return this.table;
    }

    @Override
    String metadataTableName() {
        return "manifests";
    }

    @Override
    public TableScan newScan() {
        return new SnapshotsTableScan();
    }

    @Override
    public String location() {
        return this.ops.current().file().location();
    }

    @Override
    public Schema schema() {
        return SNAPSHOT_SCHEMA;
    }

    protected DataTask task(TableScan scan) {
        return StaticDataTask.of(this.ops.io().newInputFile(scan.snapshot().manifestListLocation()), scan.snapshot().manifests(), this::manifestFileToRow);
    }

    private StaticDataTask.Row manifestFileToRow(ManifestFile manifest) {
        return StaticDataTask.Row.of(manifest.path(), manifest.length(), manifest.partitionSpecId(), manifest.snapshotId(), manifest.addedFilesCount(), manifest.existingFilesCount(), manifest.deletedFilesCount(), this.partitionSummariesToRows(manifest.partitions()));
    }

    private List<StaticDataTask.Row> partitionSummariesToRows(List<ManifestFile.PartitionFieldSummary> summaries) {
        ArrayList<StaticDataTask.Row> rows = Lists.newArrayList();
        for (int i = 0; i < this.spec.fields().size(); ++i) {
            ManifestFile.PartitionFieldSummary summary = summaries.get(i);
            rows.add(StaticDataTask.Row.of(summary.containsNull(), this.spec.fields().get(i).transform().toHumanString(Conversions.fromByteBuffer(this.spec.partitionType().fields().get(i).type(), summary.lowerBound())), this.spec.fields().get(i).transform().toHumanString(Conversions.fromByteBuffer(this.spec.partitionType().fields().get(i).type(), summary.upperBound()))));
        }
        return rows;
    }

    private class SnapshotsTableScan
    extends StaticTableScan {
        SnapshotsTableScan() {
            super(ManifestsTable.this.ops, ManifestsTable.this.table, SNAPSHOT_SCHEMA, ManifestsTable.this::task);
        }
    }
}

