/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotProducer;
import org.apache.iceberg.SnapshotSummary;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.StrictMetricsEvaluator;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.shaded.com.google.common.base.Joiner;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.shaded.com.google.common.collect.Iterables;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.com.google.common.collect.Sets;
import org.apache.iceberg.util.BinPacking;
import org.apache.iceberg.util.CharSequenceWrapper;
import org.apache.iceberg.util.ManifestFileUtil;
import org.apache.iceberg.util.StructLikeWrapper;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MergingSnapshotProducer<ThisT>
extends SnapshotProducer<ThisT> {
    private static final Logger LOG = LoggerFactory.getLogger(MergingSnapshotProducer.class);
    private static final Joiner COMMA = Joiner.on(",");
    private final TableOperations ops;
    private final PartitionSpec spec;
    private final long manifestTargetSizeBytes;
    private final int minManifestsCountToMerge;
    private final SnapshotSummary.Builder summaryBuilder = SnapshotSummary.builder();
    private final boolean mergeEnabled;
    private final AtomicInteger manifestCount = new AtomicInteger(0);
    private final List<DataFile> newFiles = Lists.newArrayList();
    private final List<ManifestFile> appendManifests = Lists.newArrayList();
    private final SnapshotSummary.Builder appendedManifestsSummary = SnapshotSummary.builder();
    private final Set<CharSequenceWrapper> deletePaths = Sets.newHashSet();
    private final Set<StructLikeWrapper> deleteFilePartitions = Sets.newHashSet();
    private final Set<StructLikeWrapper> dropPartitions = Sets.newHashSet();
    private Expression deleteExpression = Expressions.alwaysFalse();
    private boolean hasPathOnlyDeletes = false;
    private boolean failAnyDelete = false;
    private boolean failMissingDeletePaths = false;
    private ManifestFile cachedNewManifest = null;
    private boolean hasNewFiles = false;
    private final Map<List<ManifestFile>, ManifestFile> mergeManifests = Maps.newConcurrentMap();
    private final Map<ManifestFile, ManifestFile> filteredManifests = Maps.newConcurrentMap();
    private final Map<ManifestFile, Iterable<DataFile>> filteredManifestToDeletedFiles = Maps.newConcurrentMap();
    private boolean filterUpdated = false;

    MergingSnapshotProducer(TableOperations ops) {
        super(ops);
        this.ops = ops;
        this.spec = ops.current().spec();
        this.manifestTargetSizeBytes = ops.current().propertyAsLong("commit.manifest.target-size-bytes", 0x800000L);
        this.minManifestsCountToMerge = ops.current().propertyAsInt("commit.manifest.min-count-to-merge", 100);
        this.mergeEnabled = ops.current().propertyAsBoolean("commit.manifest-merge.enabled", true);
    }

    @Override
    public ThisT set(String property, String value) {
        this.summaryBuilder.set(property, value);
        return this.self();
    }

    protected PartitionSpec writeSpec() {
        return this.spec;
    }

    protected Expression rowFilter() {
        return this.deleteExpression;
    }

    protected List<DataFile> addedFiles() {
        return ImmutableList.copyOf(this.newFiles);
    }

    protected void failAnyDelete() {
        this.failAnyDelete = true;
    }

    protected void failMissingDeletePaths() {
        this.failMissingDeletePaths = true;
    }

    protected void deleteByRowFilter(Expression expr) {
        Preconditions.checkNotNull(expr, "Cannot delete files using filter: null");
        this.filterUpdated = true;
        this.deleteExpression = Expressions.or(this.deleteExpression, expr);
    }

    protected void dropPartition(StructLike partition) {
        this.dropPartitions.add(StructLikeWrapper.wrap(partition));
    }

    protected void delete(DataFile file) {
        Preconditions.checkNotNull(file, "Cannot delete file: null");
        this.filterUpdated = true;
        this.deletePaths.add(CharSequenceWrapper.wrap(file.path()));
        this.deleteFilePartitions.add(StructLikeWrapper.wrap(file.partition()));
    }

    protected void delete(CharSequence path) {
        Preconditions.checkNotNull(path, "Cannot delete file path: null");
        this.filterUpdated = true;
        this.hasPathOnlyDeletes = true;
        this.deletePaths.add(CharSequenceWrapper.wrap(path));
    }

    protected void add(DataFile file) {
        this.hasNewFiles = true;
        this.newFiles.add(file);
    }

    protected void add(ManifestFile manifest) {
        try (ManifestReader reader = ManifestReader.read(this.ops.io().newInputFile(manifest.path()), this.ops.current()::spec);){
            this.appendManifests.add(ManifestWriter.copyAppendManifest(reader, this.manifestPath(this.manifestCount.getAndIncrement()), this.snapshotId(), this.appendedManifestsSummary));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to close manifest: %s", manifest);
        }
    }

    @Override
    protected Map<String, String> summary() {
        return this.summaryBuilder.build();
    }

    @Override
    public List<ManifestFile> apply(TableMetadata base) {
        this.summaryBuilder.clear();
        this.summaryBuilder.merge(this.appendedManifestsSummary);
        if (this.filterUpdated) {
            this.cleanUncommittedFilters(SnapshotProducer.EMPTY_SET);
            this.filterUpdated = false;
        }
        Snapshot current = base.currentSnapshot();
        TreeMap<Integer, List<ManifestFile>> groups = Maps.newTreeMap(Comparator.reverseOrder());
        StrictMetricsEvaluator metricsEvaluator = new StrictMetricsEvaluator(this.ops.current().schema(), this.deleteExpression);
        try {
            List<Object> filtered;
            Iterable<ManifestFile> newManifests;
            if (this.newFiles.size() > 0) {
                for (DataFile file : this.newFiles) {
                    this.summaryBuilder.addedFile(this.spec, file);
                }
                newManifests = Iterables.concat(ImmutableList.of(this.newFilesAsManifest()), this.appendManifests);
            } else {
                newManifests = this.appendManifests;
            }
            if (current != null) {
                List<ManifestFile> manifests = current.manifests();
                filtered = Arrays.asList(this.filterManifests(metricsEvaluator, manifests));
            } else {
                filtered = ImmutableList.of();
            }
            Iterable<ManifestFile> unmergedManifests = Iterables.filter(Iterables.concat(newManifests, filtered), manifest -> manifest.hasAddedFiles() || manifest.hasExistingFiles() || manifest.snapshotId().longValue() == this.snapshotId());
            Set<CharSequenceWrapper> deletedFiles = this.deletedFiles(unmergedManifests);
            ArrayList<ManifestFile> manifests = Lists.newArrayList();
            if (this.mergeEnabled) {
                this.groupManifestsByPartitionSpec(groups, unmergedManifests);
                for (Map.Entry entry : groups.entrySet()) {
                    Iterables.addAll(manifests, this.mergeGroup((Integer)entry.getKey(), (List)entry.getValue()));
                }
            } else {
                Iterables.addAll(manifests, unmergedManifests);
            }
            ValidationException.check(!this.failMissingDeletePaths || deletedFiles.containsAll(this.deletePaths), "Missing required files to delete: %s", COMMA.join(Iterables.transform(Iterables.filter(this.deletePaths, path -> !deletedFiles.contains(path)), CharSequenceWrapper::get)));
            return manifests;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to create snapshot manifest list", new Object[0]);
        }
    }

    private ManifestFile[] filterManifests(StrictMetricsEvaluator metricsEvaluator, List<ManifestFile> manifests) throws IOException {
        ManifestFile[] filtered = new ManifestFile[manifests.size()];
        Tasks.range(filtered.length).stopOnFailure().throwFailureWhenFinished().executeWith(ThreadPools.getWorkerPool()).run(index -> {
            ManifestFile manifest;
            filtered[index.intValue()] = manifest = this.filterManifest(metricsEvaluator, (ManifestFile)manifests.get((int)index));
        }, IOException.class);
        return filtered;
    }

    private Set<CharSequenceWrapper> deletedFiles(Iterable<ManifestFile> manifests) {
        HashSet<CharSequenceWrapper> deletedFiles = Sets.newHashSet();
        for (ManifestFile manifest : manifests) {
            PartitionSpec manifestSpec = this.ops.current().spec(manifest.partitionSpecId());
            Iterable<DataFile> manifestDeletes = this.filteredManifestToDeletedFiles.get(manifest);
            if (manifestDeletes == null) continue;
            for (DataFile file : manifestDeletes) {
                this.summaryBuilder.deletedFile(manifestSpec, file);
                deletedFiles.add(CharSequenceWrapper.wrap(file.path()));
            }
        }
        return deletedFiles;
    }

    private void groupManifestsByPartitionSpec(Map<Integer, List<ManifestFile>> groups, Iterable<ManifestFile> filtered) {
        for (ManifestFile manifest : filtered) {
            List<ManifestFile> group = groups.get(manifest.partitionSpecId());
            if (group != null) {
                group.add(manifest);
                continue;
            }
            group = Lists.newArrayList();
            group.add(manifest);
            groups.put(manifest.partitionSpecId(), group);
        }
    }

    private void cleanUncommittedMerges(Set<ManifestFile> committed) {
        ArrayList<Map.Entry<List<ManifestFile>, ManifestFile>> entries = Lists.newArrayList(this.mergeManifests.entrySet());
        for (Map.Entry entry : entries) {
            ManifestFile merged = (ManifestFile)entry.getValue();
            if (committed.contains(merged)) continue;
            this.deleteFile(merged.path());
            this.mergeManifests.remove(entry.getKey());
        }
    }

    private void cleanUncommittedFilters(Set<ManifestFile> committed) {
        ArrayList<Map.Entry<ManifestFile, ManifestFile>> filterEntries = Lists.newArrayList(this.filteredManifests.entrySet());
        for (Map.Entry entry : filterEntries) {
            ManifestFile manifest = (ManifestFile)entry.getKey();
            ManifestFile filtered = (ManifestFile)entry.getValue();
            if (committed.contains(filtered)) continue;
            if (!manifest.equals(filtered)) {
                this.deleteFile(filtered.path());
            }
            this.filteredManifests.remove(manifest);
        }
    }

    private void cleanUncommittedAppends(Set<ManifestFile> committed) {
        if (this.cachedNewManifest != null && !committed.contains(this.cachedNewManifest)) {
            this.deleteFile(this.cachedNewManifest.path());
            this.cachedNewManifest = null;
        }
        for (ManifestFile manifest : this.appendManifests) {
            if (committed.contains(manifest)) continue;
            this.deleteFile(manifest.path());
        }
    }

    @Override
    protected void cleanUncommitted(Set<ManifestFile> committed) {
        this.cleanUncommittedMerges(committed);
        this.cleanUncommittedFilters(committed);
        this.cleanUncommittedAppends(committed);
    }

    private boolean canContainDeletedFiles(ManifestFile manifest) {
        boolean canContainExpressionDeletes;
        if (this.deleteExpression != null && this.deleteExpression != Expressions.alwaysFalse()) {
            ManifestEvaluator manifestEvaluator = ManifestEvaluator.forRowFilter(this.deleteExpression, this.ops.current().spec(), true);
            canContainExpressionDeletes = manifestEvaluator.eval(manifest);
        } else {
            canContainExpressionDeletes = false;
        }
        boolean canContainDroppedPartitions = this.dropPartitions.size() > 0 ? ManifestFileUtil.canContainAny(manifest, Iterables.transform(this.dropPartitions, StructLikeWrapper::get), specId -> this.ops.current().spec((int)specId)) : false;
        boolean canContainDroppedFiles = this.hasPathOnlyDeletes ? true : (this.deletePaths.size() > 0 ? ManifestFileUtil.canContainAny(manifest, Iterables.transform(this.deleteFilePartitions, StructLikeWrapper::get), specId -> this.ops.current().spec((int)specId)) : false);
        return canContainExpressionDeletes || canContainDroppedPartitions || canContainDroppedFiles;
    }

    private ManifestFile filterManifest(StrictMetricsEvaluator metricsEvaluator, ManifestFile manifest) throws IOException {
        boolean hasLiveFiles;
        ManifestFile cached = this.filteredManifests.get(manifest);
        if (cached != null) {
            return cached;
        }
        boolean bl = hasLiveFiles = manifest.hasAddedFiles() || manifest.hasExistingFiles();
        if (!hasLiveFiles || !this.canContainDeletedFiles(manifest)) {
            this.filteredManifests.put(manifest, manifest);
            return manifest;
        }
        try (ManifestReader reader = ManifestReader.read(this.ops.io().newInputFile(manifest.path()), this.ops.current()::spec);){
            CharSequenceWrapper pathWrapper = CharSequenceWrapper.wrap("");
            StructLikeWrapper partitionWrapper = StructLikeWrapper.wrap(null);
            boolean hasDeletedFiles = this.manifestHasDeletedFiles(metricsEvaluator, reader, pathWrapper, partitionWrapper);
            if (!hasDeletedFiles) {
                this.filteredManifests.put(manifest, manifest);
                ManifestFile manifestFile = manifest;
                return manifestFile;
            }
            ManifestFile manifestFile = this.filterManifestWithDeletedFiles(metricsEvaluator, manifest, reader, pathWrapper, partitionWrapper);
            return manifestFile;
        }
    }

    private boolean manifestHasDeletedFiles(StrictMetricsEvaluator metricsEvaluator, ManifestReader reader, CharSequenceWrapper pathWrapper, StructLikeWrapper partitionWrapper) {
        Evaluator inclusive = this.extractInclusiveDeleteExpression(reader);
        Evaluator strict = this.extractStrictDeleteExpression(reader);
        boolean hasDeletedFiles = false;
        for (ManifestEntry entry : reader.entries()) {
            boolean fileDelete;
            DataFile file = entry.file();
            boolean bl = fileDelete = this.deletePaths.contains(pathWrapper.set(file.path())) || this.dropPartitions.contains(partitionWrapper.set(file.partition()));
            if (!fileDelete && !inclusive.eval(file.partition())) continue;
            ValidationException.check(fileDelete || strict.eval(file.partition()) || metricsEvaluator.eval(file), "Cannot delete file where some, but not all, rows match filter %s: %s", this.deleteExpression, file.path());
            hasDeletedFiles = true;
            if (!this.failAnyDelete) break;
            throw new DeleteException(this.writeSpec().partitionToPath(file.partition()));
        }
        return hasDeletedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManifestFile filterManifestWithDeletedFiles(StrictMetricsEvaluator metricsEvaluator, ManifestFile manifest, ManifestReader reader, CharSequenceWrapper pathWrapper, StructLikeWrapper partitionWrapper) throws IOException {
        Evaluator inclusive = this.extractInclusiveDeleteExpression(reader);
        Evaluator strict = this.extractStrictDeleteExpression(reader);
        ArrayList deletedFiles = Lists.newArrayList();
        HashSet deletedPaths = Sets.newHashSet();
        OutputFile filteredCopy = this.manifestPath(this.manifestCount.getAndIncrement());
        try (ManifestWriter writer = new ManifestWriter(reader.spec(), filteredCopy, this.snapshotId());){
            reader.entries().forEach(entry -> {
                boolean fileDelete;
                DataFile file = entry.file();
                boolean bl = fileDelete = this.deletePaths.contains(pathWrapper.set(file.path())) || this.dropPartitions.contains(partitionWrapper.set(file.partition()));
                if (entry.status() != ManifestEntry.Status.DELETED) {
                    if (fileDelete || inclusive.eval(file.partition())) {
                        ValidationException.check(fileDelete || strict.eval(file.partition()) || metricsEvaluator.eval(file), "Cannot delete file where some, but not all, rows match filter %s: %s", this.deleteExpression, file.path());
                        writer.delete((ManifestEntry)entry);
                        CharSequenceWrapper wrapper = CharSequenceWrapper.wrap(entry.file().path());
                        if (deletedPaths.contains(wrapper)) {
                            LOG.warn("Deleting a duplicate path from manifest {}: {}", (Object)manifest.path(), (Object)wrapper.get());
                            this.summaryBuilder.incrementDuplicateDeletes();
                        } else {
                            deletedFiles.add(entry.file().copyWithoutStats());
                        }
                        deletedPaths.add(wrapper);
                    } else {
                        writer.existing((ManifestEntry)entry);
                    }
                }
            });
        }
        ManifestFile filtered = writer.toManifestFile();
        this.filteredManifests.put(manifest, filtered);
        this.filteredManifestToDeletedFiles.put(filtered, deletedFiles);
        return filtered;
    }

    private Evaluator extractStrictDeleteExpression(ManifestReader reader) {
        Expression strictExpr = Projections.strict(reader.spec()).project(this.deleteExpression);
        return new Evaluator(reader.spec().partitionType(), strictExpr);
    }

    private Evaluator extractInclusiveDeleteExpression(ManifestReader reader) {
        Expression inclusiveExpr = Projections.inclusive(reader.spec()).project(this.deleteExpression);
        return new Evaluator(reader.spec().partitionType(), inclusiveExpr);
    }

    private Iterable<ManifestFile> mergeGroup(int specId, List<ManifestFile> group) throws IOException {
        BinPacking.ListPacker<ManifestFile> packer = new BinPacking.ListPacker<ManifestFile>(this.manifestTargetSizeBytes, 1, false);
        List<List<ManifestFile>> bins = packer.packEnd(group, manifest -> manifest.length());
        List[] binResults = (List[])Array.newInstance(List.class, bins.size());
        Tasks.range(bins.size()).stopOnFailure().throwFailureWhenFinished().executeWith(ThreadPools.getWorkerPool()).run(index -> {
            ArrayList<ManifestFile> outputManifests;
            List bin = (List)bins.get((int)index);
            binResults[index.intValue()] = outputManifests = Lists.newArrayList();
            if (bin.size() == 1) {
                outputManifests.add((ManifestFile)bin.get(0));
                return;
            }
            if (bin.contains(this.cachedNewManifest) && bin.size() < this.minManifestsCountToMerge) {
                outputManifests.addAll(bin);
            } else {
                outputManifests.add(this.createManifest(specId, bin));
            }
        }, IOException.class);
        return Iterables.concat(binResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManifestFile createManifest(int specId, List<ManifestFile> bin) throws IOException {
        if (this.mergeManifests.containsKey(bin)) {
            return this.mergeManifests.get(bin);
        }
        OutputFile out = this.manifestPath(this.manifestCount.getAndIncrement());
        try (ManifestWriter writer = new ManifestWriter(this.ops.current().spec(specId), out, this.snapshotId());){
            for (ManifestFile manifest : bin) {
                ManifestReader reader = ManifestReader.read(this.ops.io().newInputFile(manifest.path()), this.ops.current()::spec);
                Throwable throwable = null;
                try {
                    for (ManifestEntry entry : reader.entries()) {
                        if (entry.status() == ManifestEntry.Status.DELETED) {
                            if (entry.snapshotId() != this.snapshotId()) continue;
                            writer.addEntry(entry);
                            continue;
                        }
                        if (entry.status() == ManifestEntry.Status.ADDED && entry.snapshotId() == this.snapshotId()) {
                            writer.addEntry(entry);
                            continue;
                        }
                        writer.existing(entry);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    MergingSnapshotProducer.$closeResource(throwable, reader);
                }
            }
        }
        ManifestFile manifest = writer.toManifestFile();
        this.mergeManifests.put(bin, manifest);
        return manifest;
    }

    private ManifestFile newFilesAsManifest() throws IOException {
        if (this.hasNewFiles && this.cachedNewManifest != null) {
            this.deleteFile(this.cachedNewManifest.path());
            this.cachedNewManifest = null;
        }
        if (this.cachedNewManifest == null) {
            OutputFile out = this.manifestPath(this.manifestCount.getAndIncrement());
            try (ManifestWriter writer = new ManifestWriter(this.spec, out, this.snapshotId());){
                writer.addAll(this.newFiles);
            }
            this.cachedNewManifest = writer.toManifestFile();
            this.hasNewFiles = false;
        }
        return this.cachedNewManifest;
    }

    protected static class DeleteException
    extends ValidationException {
        private final String partition;

        private DeleteException(String partition) {
            super("Operation would delete existing data", new Object[0]);
            this.partition = partition;
        }

        public String partition() {
            return this.partition;
        }
    }
}

