/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;

public class MetricsModes {
    private static final Pattern TRUNCATE = Pattern.compile("truncate\\((\\d+)\\)");

    private MetricsModes() {
    }

    public static MetricsMode fromString(String mode) {
        if ("none".equalsIgnoreCase(mode)) {
            return None.get();
        }
        if ("counts".equalsIgnoreCase(mode)) {
            return Counts.get();
        }
        if ("full".equalsIgnoreCase(mode)) {
            return Full.get();
        }
        Matcher truncateMatcher = TRUNCATE.matcher(mode.toLowerCase(Locale.ENGLISH));
        if (truncateMatcher.matches()) {
            int length = Integer.parseInt(truncateMatcher.group(1));
            return Truncate.withLength(length);
        }
        throw new IllegalArgumentException("Invalid metrics mode: " + mode);
    }

    public static class Full
    implements MetricsMode {
        private static final Full INSTANCE = new Full();

        public static Full get() {
            return INSTANCE;
        }

        public String toString() {
            return "full";
        }
    }

    public static class Truncate
    implements MetricsMode {
        private final int length;

        private Truncate(int length) {
            this.length = length;
        }

        public static Truncate withLength(int length) {
            Preconditions.checkArgument(length > 0, "Truncate length should be positive");
            return new Truncate(length);
        }

        public int length() {
            return this.length;
        }

        public String toString() {
            return String.format("truncate(%d)", this.length);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Truncate truncate = (Truncate)obj;
            return this.length == truncate.length;
        }

        public int hashCode() {
            return Objects.hash(this.length);
        }
    }

    public static class Counts
    implements MetricsMode {
        private static final Counts INSTANCE = new Counts();

        public static Counts get() {
            return INSTANCE;
        }

        public String toString() {
            return "counts";
        }
    }

    public static class None
    implements MetricsMode {
        private static final None INSTANCE = new None();

        public static None get() {
            return INSTANCE;
        }

        public String toString() {
            return "none";
        }
    }

    public static interface MetricsMode {
    }
}

