/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import io.netty.util.internal.ConcurrentSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.shaded.com.google.common.base.Joiner;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.com.google.common.collect.Sets;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoveSnapshots
implements ExpireSnapshots {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveSnapshots.class);
    private final Consumer<String> defaultDelete = new Consumer<String>(){

        @Override
        public void accept(String file) {
            RemoveSnapshots.this.ops.io().deleteFile(file);
        }
    };
    private final TableOperations ops;
    private final Set<Long> idsToRemove = Sets.newHashSet();
    private TableMetadata base;
    private Long expireOlderThan = null;
    private Consumer<String> deleteFunc = this.defaultDelete;
    private static final Schema MANIFEST_PROJECTION = ManifestFile.schema().select("manifest_path", "added_snapshot_id", "deleted_data_files_count");

    RemoveSnapshots(TableOperations ops) {
        this.ops = ops;
        this.base = ops.current();
    }

    @Override
    public ExpireSnapshots expireSnapshotId(long expireSnapshotId) {
        LOG.info("Expiring snapshot with id: {}", (Object)expireSnapshotId);
        this.idsToRemove.add(expireSnapshotId);
        return this;
    }

    @Override
    public ExpireSnapshots expireOlderThan(long timestampMillis) {
        LOG.info("Expiring snapshots older than: {} ({})", (Object)new Date(timestampMillis), (Object)timestampMillis);
        this.expireOlderThan = timestampMillis;
        return this;
    }

    @Override
    public ExpireSnapshots deleteWith(Consumer<String> newDeleteFunc) {
        this.deleteFunc = newDeleteFunc;
        return this;
    }

    @Override
    public List<Snapshot> apply() {
        TableMetadata updated = this.internalApply();
        ArrayList<Snapshot> removed = Lists.newArrayList(this.base.snapshots());
        removed.removeAll(updated.snapshots());
        return removed;
    }

    private TableMetadata internalApply() {
        this.base = this.ops.refresh();
        return this.base.removeSnapshotsIf(snapshot -> this.idsToRemove.contains(snapshot.snapshotId()) || this.expireOlderThan != null && snapshot.timestampMillis() < this.expireOlderThan);
    }

    @Override
    public void commit() {
        Tasks.foreach(this.ops).retry(this.base.propertyAsInt("commit.retry.num-retries", 4)).exponentialBackoff(this.base.propertyAsInt("commit.retry.min-wait-ms", 100), this.base.propertyAsInt("commit.retry.max-wait-ms", 60000), this.base.propertyAsInt("commit.retry.total-timeout-ms", 1800000), 2.0).onlyRetryOn((Class<Exception>)CommitFailedException.class).run(item -> {
            TableMetadata updated = this.internalApply();
            if (updated.snapshots().size() != this.base.snapshots().size()) {
                this.ops.commit(this.base, updated);
            }
        });
        this.cleanExpiredSnapshots();
    }

    private void cleanExpiredSnapshots() {
        TableMetadata current = this.ops.refresh();
        HashSet<Long> validIds = Sets.newHashSet();
        for (Snapshot snapshot : current.snapshots()) {
            validIds.add(snapshot.snapshotId());
        }
        HashSet<Long> expiredIds = Sets.newHashSet();
        for (Snapshot snapshot : this.base.snapshots()) {
            long snapshotId = snapshot.snapshotId();
            if (validIds.contains(snapshotId)) continue;
            LOG.info("Expired snapshot: {}", (Object)snapshot);
            expiredIds.add(snapshotId);
        }
        if (expiredIds.isEmpty()) {
            return;
        }
        LOG.info("Committed snapshot changes; cleaning up expired manifests and data files.");
        this.cleanExpiredFiles(current.snapshots(), validIds, expiredIds);
    }

    private void cleanExpiredFiles(List<Snapshot> snapshots, Set<Long> validIds, Set<Long> expiredIds) {
        HashSet<Long> ancestorIds = Sets.newHashSet(SnapshotUtil.ancestorIds(this.base.currentSnapshot(), this.base::snapshot));
        HashSet<String> validManifests = Sets.newHashSet();
        HashSet<String> manifestsToScan = Sets.newHashSet();
        for (Snapshot snapshot : snapshots) {
            try {
                CloseableIterable<ManifestFile> manifests = this.readManifestFiles(snapshot);
                Object object = null;
                try {
                    for (ManifestFile manifest : manifests) {
                        validManifests.add(manifest.path());
                        boolean fromValidSnapshots = validIds.contains(manifest.snapshotId());
                        boolean isFromAncestor = ancestorIds.contains(manifest.snapshotId());
                        if (fromValidSnapshots || !isFromAncestor || !manifest.hasDeletedFiles()) continue;
                        manifestsToScan.add(manifest.path());
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (manifests == null) continue;
                    RemoveSnapshots.$closeResource((Throwable)object, manifests);
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to close manifest list: %s", snapshot.manifestListLocation());
            }
        }
        HashSet<String> manifestListsToDelete = Sets.newHashSet();
        HashSet<String> manifestsToDelete = Sets.newHashSet();
        HashSet<String> manifestsToRevert = Sets.newHashSet();
        for (Snapshot snapshot : this.base.snapshots()) {
            long snapshotId = snapshot.snapshotId();
            if (validIds.contains(snapshotId)) continue;
            try (CloseableIterable<ManifestFile> manifests = this.readManifestFiles(snapshot);){
                for (ManifestFile manifest : manifests) {
                    if (validManifests.contains(manifest.path())) continue;
                    manifestsToDelete.add(manifest.path());
                    boolean isFromAncestor = ancestorIds.contains(manifest.snapshotId());
                    boolean isFromExpiringSnapshot = expiredIds.contains(manifest.snapshotId());
                    if (isFromAncestor && manifest.hasDeletedFiles()) {
                        manifestsToScan.add(manifest.path());
                    }
                    if (isFromAncestor || !isFromExpiringSnapshot || !manifest.hasAddedFiles()) continue;
                    manifestsToRevert.add(manifest.path());
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to close manifest list: %s", snapshot.manifestListLocation());
            }
            if (snapshot.manifestListLocation() == null) continue;
            manifestListsToDelete.add(snapshot.manifestListLocation());
        }
        this.deleteDataFiles(manifestsToScan, manifestsToRevert, validIds);
        this.deleteMetadataFiles(manifestsToDelete, manifestListsToDelete);
    }

    private void deleteMetadataFiles(Set<String> manifestsToDelete, Set<String> manifestListsToDelete) {
        LOG.warn("Manifests to delete: {}", (Object)Joiner.on(", ").join(manifestsToDelete));
        Tasks.foreach(manifestsToDelete).noRetry().suppressFailureWhenFinished().onFailure((manifest, exc) -> LOG.warn("Delete failed for manifest: {}", manifest, (Object)exc)).run(this.deleteFunc::accept);
        Tasks.foreach(manifestListsToDelete).noRetry().suppressFailureWhenFinished().onFailure((list, exc) -> LOG.warn("Delete failed for manifest list: {}", list, (Object)exc)).run(this.deleteFunc::accept);
    }

    private void deleteDataFiles(Set<String> manifestsToScan, Set<String> manifestsToRevert, Set<Long> validIds) {
        Set<String> filesToDelete = this.findFilesToDelete(manifestsToScan, manifestsToRevert, validIds);
        Tasks.foreach(filesToDelete).noRetry().suppressFailureWhenFinished().onFailure((file, exc) -> LOG.warn("Delete failed for data file: {}", file, (Object)exc)).run(file -> this.deleteFunc.accept((String)file));
    }

    private Set<String> findFilesToDelete(Set<String> manifestsToScan, Set<String> manifestsToRevert, Set<Long> validIds) {
        ConcurrentSet filesToDelete = new ConcurrentSet();
        Tasks.foreach(manifestsToScan).noRetry().suppressFailureWhenFinished().executeWith(ThreadPools.getWorkerPool()).onFailure((item, exc) -> LOG.warn("Failed to get deleted files: this may cause orphaned data files", (Throwable)exc)).run(arg_0 -> this.lambda$findFilesToDelete$7(validIds, (Set)filesToDelete, arg_0));
        Tasks.foreach(manifestsToRevert).noRetry().suppressFailureWhenFinished().executeWith(ThreadPools.getWorkerPool()).onFailure((item, exc) -> LOG.warn("Failed to get added files: this may cause orphaned data files", (Throwable)exc)).run(arg_0 -> this.lambda$findFilesToDelete$9((Set)filesToDelete, arg_0));
        return filesToDelete;
    }

    private CloseableIterable<ManifestFile> readManifestFiles(Snapshot snapshot) {
        if (snapshot.manifestListLocation() != null) {
            return Avro.read(this.ops.io().newInputFile(snapshot.manifestListLocation())).rename("manifest_file", GenericManifestFile.class.getName()).project(MANIFEST_PROJECTION).reuseContainers(true).build();
        }
        return CloseableIterable.withNoopClose(snapshot.manifests());
    }

    private /* synthetic */ void lambda$findFilesToDelete$9(Set filesToDelete, String manifest) throws RuntimeException {
        try {
            ManifestReader reader = ManifestReader.read(this.ops.io().newInputFile(manifest), this.ops.current()::spec);
            Throwable throwable = null;
            try {
                for (ManifestEntry entry : reader.entries()) {
                    if (entry.status() != ManifestEntry.Status.ADDED) continue;
                    filesToDelete.add(entry.file().path().toString());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    RemoveSnapshots.$closeResource(throwable, reader);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to read manifest file: %s", manifest);
        }
    }

    private /* synthetic */ void lambda$findFilesToDelete$7(Set validIds, Set filesToDelete, String manifest) throws RuntimeException {
        try {
            ManifestReader reader = ManifestReader.read(this.ops.io().newInputFile(manifest), this.ops.current()::spec);
            Throwable throwable = null;
            try {
                for (ManifestEntry entry : reader.entries()) {
                    if (entry.status() != ManifestEntry.Status.DELETED || validIds.contains(entry.snapshotId())) continue;
                    filesToDelete.add(entry.file().path().toString());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    RemoveSnapshots.$closeResource(throwable, reader);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to read manifest file: %s", manifest);
        }
    }
}

