/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.Rollback;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;

class RollbackToSnapshot
implements Rollback {
    private final TableOperations ops;
    private TableMetadata base = null;
    private Long targetSnapshotId = null;

    RollbackToSnapshot(TableOperations ops) {
        this.ops = ops;
        this.base = ops.current();
    }

    @Override
    public Rollback toSnapshotId(long snapshotId) {
        Preconditions.checkArgument(this.base.snapshot(snapshotId) != null, "Cannot roll back to unknown snapshot id: %s", snapshotId);
        this.targetSnapshotId = snapshotId;
        return this;
    }

    @Override
    public Rollback toSnapshotAtTime(long timestampMillis) {
        long snapshotId = 0L;
        long snapshotTimestamp = 0L;
        for (Snapshot snapshot : this.base.snapshots()) {
            if (snapshot.timestampMillis() >= timestampMillis || snapshot.timestampMillis() <= snapshotTimestamp) continue;
            snapshotId = snapshot.snapshotId();
            snapshotTimestamp = snapshot.timestampMillis();
        }
        Preconditions.checkArgument(this.base.snapshot(snapshotId) != null, "Cannot roll back, no valid snapshot older than: %s", timestampMillis);
        this.targetSnapshotId = snapshotId;
        return this;
    }

    @Override
    public Snapshot apply() {
        ValidationException.check(this.targetSnapshotId != null, "Cannot roll back to unknown version: call toSnapshotId or toSnapshotAtTime", new Object[0]);
        return this.base.snapshot(this.targetSnapshotId);
    }

    @Override
    public void commit() {
        this.ops.commit(this.base, this.base.rollbackTo(this.apply()));
    }
}

