/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.com.google.common.collect.Multimap;
import org.apache.iceberg.shaded.com.google.common.collect.Multimaps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaUpdate
implements UpdateSchema {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaUpdate.class);
    private static final int TABLE_ROOT_ID = -1;
    private final TableOperations ops;
    private final TableMetadata base;
    private final Schema schema;
    private final List<Integer> deletes = Lists.newArrayList();
    private final Map<Integer, Types.NestedField> updates = Maps.newHashMap();
    private final Multimap<Integer, Types.NestedField> adds = Multimaps.newListMultimap(Maps.newHashMap(), Lists::newArrayList);
    private int lastColumnId;

    SchemaUpdate(TableOperations ops) {
        this.ops = ops;
        this.base = ops.current();
        this.schema = this.base.schema();
        this.lastColumnId = this.base.lastColumnId();
    }

    SchemaUpdate(Schema schema, int lastColumnId) {
        this.ops = null;
        this.base = null;
        this.schema = schema;
        this.lastColumnId = lastColumnId;
    }

    @Override
    public UpdateSchema addColumn(String name, Type type, String doc) {
        Preconditions.checkArgument(!name.contains("."), "Cannot add column with ambiguous name: %s, use addColumn(parent, name, type)", (Object)name);
        return this.addColumn(null, name, type, doc);
    }

    @Override
    public UpdateSchema addColumn(String parent, String name, Type type, String doc) {
        int parentId = -1;
        if (parent != null) {
            Types.NestedField parentField = this.schema.findField(parent);
            Preconditions.checkArgument(parentField != null, "Cannot find parent struct: %s", (Object)parent);
            Type parentType = parentField.type();
            if (parentType.isNestedType()) {
                Type.NestedType nested = parentType.asNestedType();
                if (nested.isMapType()) {
                    parentField = nested.asMapType().fields().get(1);
                } else if (nested.isListType()) {
                    parentField = nested.asListType().fields().get(0);
                }
            }
            Preconditions.checkArgument(parentField.type().isNestedType() && parentField.type().asNestedType().isStructType(), "Cannot add to non-struct column: %s: %s", (Object)parent, (Object)parentField.type());
            parentId = parentField.fieldId();
            Preconditions.checkArgument(!this.deletes.contains(parentId), "Cannot add to a column that will be deleted: %s", (Object)parent);
            Preconditions.checkArgument(this.schema.findField(parent + "." + name) == null, "Cannot add column, name already exists: %s.%s", (Object)parent, (Object)name);
        } else {
            Preconditions.checkArgument(this.schema.findField(name) == null, "Cannot add column, name already exists: %s", (Object)name);
        }
        int newId = this.assignNewColumnId();
        this.adds.put(parentId, Types.NestedField.optional(newId, name, TypeUtil.assignFreshIds(type, this::assignNewColumnId), doc));
        return this;
    }

    @Override
    public UpdateSchema deleteColumn(String name) {
        Types.NestedField field = this.schema.findField(name);
        Preconditions.checkArgument(field != null, "Cannot delete missing column: %s", (Object)name);
        Preconditions.checkArgument(!this.adds.containsKey(field.fieldId()), "Cannot delete a column that has additions: %s", (Object)name);
        Preconditions.checkArgument(!this.updates.containsKey(field.fieldId()), "Cannot delete a column that has updates: %s", (Object)name);
        this.deletes.add(field.fieldId());
        return this;
    }

    @Override
    public UpdateSchema renameColumn(String name, String newName) {
        Types.NestedField field = this.schema.findField(name);
        Preconditions.checkArgument(field != null, "Cannot rename missing column: %s", (Object)name);
        Preconditions.checkArgument(newName != null, "Cannot rename a column to null");
        Preconditions.checkArgument(!this.deletes.contains(field.fieldId()), "Cannot rename a column that will be deleted: %s", (Object)field.name());
        int fieldId = field.fieldId();
        Types.NestedField update = this.updates.get(fieldId);
        if (update != null) {
            this.updates.put(fieldId, Types.NestedField.required(fieldId, newName, update.type(), update.doc()));
        } else {
            this.updates.put(fieldId, Types.NestedField.required(fieldId, newName, field.type(), field.doc()));
        }
        return this;
    }

    @Override
    public UpdateSchema updateColumn(String name, Type.PrimitiveType newType) {
        Types.NestedField field = this.schema.findField(name);
        Preconditions.checkArgument(field != null, "Cannot update missing column: %s", (Object)name);
        Preconditions.checkArgument(!this.deletes.contains(field.fieldId()), "Cannot update a column that will be deleted: %s", (Object)field.name());
        Preconditions.checkArgument(TypeUtil.isPromotionAllowed(field.type(), newType), "Cannot change column type: %s: %s -> %s", (Object)name, (Object)field.type(), (Object)newType);
        int fieldId = field.fieldId();
        Types.NestedField rename = this.updates.get(fieldId);
        if (rename != null) {
            this.updates.put(fieldId, Types.NestedField.required(fieldId, rename.name(), newType, rename.doc()));
        } else {
            this.updates.put(fieldId, Types.NestedField.required(fieldId, field.name(), newType, field.doc()));
        }
        return this;
    }

    @Override
    public UpdateSchema updateColumnDoc(String name, String doc) {
        Types.NestedField field = this.schema.findField(name);
        Preconditions.checkArgument(field != null, "Cannot update missing column: %s", (Object)name);
        Preconditions.checkArgument(!this.deletes.contains(field.fieldId()), "Cannot update a column that will be deleted: %s", (Object)field.name());
        int fieldId = field.fieldId();
        Types.NestedField update = this.updates.get(fieldId);
        if (update != null) {
            this.updates.put(fieldId, Types.NestedField.required(fieldId, update.name(), update.type(), doc));
        } else {
            this.updates.put(fieldId, Types.NestedField.required(fieldId, field.name(), field.type(), doc));
        }
        return this;
    }

    @Override
    public Schema apply() {
        return SchemaUpdate.applyChanges(this.schema, this.deletes, this.updates, this.adds);
    }

    @Override
    public void commit() {
        TableMetadata update = this.applyChangesToMapping(this.base.updateSchema(this.apply(), this.lastColumnId));
        this.ops.commit(this.base, update);
    }

    private int assignNewColumnId() {
        int next;
        this.lastColumnId = next = this.lastColumnId + 1;
        return next;
    }

    private TableMetadata applyChangesToMapping(TableMetadata metadata) {
        String mappingJson = metadata.property("schema.name-mapping.default", null);
        if (mappingJson != null) {
            try {
                NameMapping mapping = NameMappingParser.fromJson(mappingJson);
                NameMapping updated = MappingUtil.update(mapping, this.updates, this.adds);
                HashMap<String, String> updatedProperties = Maps.newHashMap();
                updatedProperties.putAll(metadata.properties());
                updatedProperties.put("schema.name-mapping.default", NameMappingParser.toJson(updated));
                return metadata.replaceProperties(updatedProperties);
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to update external schema mapping: {}", (Object)mappingJson, (Object)e);
            }
        }
        return metadata;
    }

    private static Schema applyChanges(Schema schema, List<Integer> deletes, Map<Integer, Types.NestedField> updates, Multimap<Integer, Types.NestedField> adds) {
        Types.StructType struct = TypeUtil.visit(schema, new ApplyChanges(deletes, updates, adds)).asNestedType().asStructType();
        return new Schema(struct.fields());
    }

    private static Types.StructType addFields(Types.StructType struct, Collection<Types.NestedField> adds) {
        ArrayList<Types.NestedField> newFields = Lists.newArrayList(struct.fields());
        newFields.addAll(adds);
        return Types.StructType.of(newFields);
    }

    private static class ApplyChanges
    extends TypeUtil.SchemaVisitor<Type> {
        private final List<Integer> deletes;
        private final Map<Integer, Types.NestedField> updates;
        private final Multimap<Integer, Types.NestedField> adds;

        private ApplyChanges(List<Integer> deletes, Map<Integer, Types.NestedField> updates, Multimap<Integer, Types.NestedField> adds) {
            this.deletes = deletes;
            this.updates = updates;
            this.adds = adds;
        }

        @Override
        public Type schema(Schema schema, Type structResult) {
            Collection<Types.NestedField> newColumns = this.adds.get(-1);
            if (newColumns != null) {
                return SchemaUpdate.addFields(structResult.asNestedType().asStructType(), newColumns);
            }
            return structResult;
        }

        @Override
        public Type struct(Types.StructType struct, List<Type> fieldResults) {
            boolean hasChange = false;
            ArrayList<Types.NestedField> newFields = Lists.newArrayListWithExpectedSize(fieldResults.size());
            for (int i = 0; i < fieldResults.size(); ++i) {
                Type resultType = fieldResults.get(i);
                if (resultType == null) {
                    hasChange = true;
                    continue;
                }
                Types.NestedField field = struct.fields().get(i);
                String name = field.name();
                String doc = field.doc();
                Types.NestedField update = this.updates.get(field.fieldId());
                if (update != null) {
                    name = update.name();
                    doc = update.doc();
                }
                if (!name.equals(field.name()) || field.type() != resultType || !Objects.equals(doc, field.doc())) {
                    hasChange = true;
                    if (field.isOptional()) {
                        newFields.add(Types.NestedField.optional(field.fieldId(), name, resultType, doc));
                        continue;
                    }
                    newFields.add(Types.NestedField.required(field.fieldId(), name, resultType, doc));
                    continue;
                }
                newFields.add(field);
            }
            if (hasChange) {
                return Types.StructType.of(newFields);
            }
            return struct;
        }

        @Override
        public Type field(Types.NestedField field, Type fieldResult) {
            int fieldId = field.fieldId();
            if (this.deletes.contains(fieldId)) {
                return null;
            }
            Types.NestedField update = this.updates.get(field.fieldId());
            if (update != null && update.type() != field.type()) {
                return update.type();
            }
            Collection<Types.NestedField> newFields = this.adds.get(fieldId);
            if (newFields != null && !newFields.isEmpty()) {
                return SchemaUpdate.addFields(fieldResult.asNestedType().asStructType(), newFields);
            }
            return fieldResult;
        }

        @Override
        public Type list(Types.ListType list, Type result) {
            Type elementResult = this.field(list.fields().get(0), result);
            if (elementResult == null) {
                throw new IllegalArgumentException("Cannot delete element type from list: " + list);
            }
            if (list.elementType() == elementResult) {
                return list;
            }
            if (list.isElementOptional()) {
                return Types.ListType.ofOptional(list.elementId(), elementResult);
            }
            return Types.ListType.ofRequired(list.elementId(), elementResult);
        }

        @Override
        public Type map(Types.MapType map, Type kResult, Type vResult) {
            int keyId = map.fields().get(0).fieldId();
            if (this.deletes.contains(keyId)) {
                throw new IllegalArgumentException("Cannot delete map keys: " + map);
            }
            if (this.updates.containsKey(keyId)) {
                throw new IllegalArgumentException("Cannot update map keys: " + map);
            }
            if (this.adds.containsKey(keyId)) {
                throw new IllegalArgumentException("Cannot add fields to map keys: " + map);
            }
            if (!map.keyType().equals(kResult)) {
                throw new IllegalArgumentException("Cannot alter map keys: " + map);
            }
            Type valueResult = this.field(map.fields().get(1), vResult);
            if (valueResult == null) {
                throw new IllegalArgumentException("Cannot delete value type from map: " + map);
            }
            if (map.valueType() == valueResult) {
                return map;
            }
            if (map.isValueOptional()) {
                return Types.MapType.ofOptional(map.keyId(), map.valueId(), map.keyType(), valueResult);
            }
            return Types.MapType.ofRequired(map.keyId(), map.valueId(), map.keyType(), valueResult);
        }

        @Override
        public Type primitive(Type.PrimitiveType primitive) {
            return primitive;
        }
    }
}

