/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.types.Types;

public class SnapshotsTable
extends BaseMetadataTable {
    private static final Schema SNAPSHOT_SCHEMA = new Schema(Types.NestedField.required(1, "committed_at", Types.TimestampType.withZone()), Types.NestedField.required(2, "snapshot_id", Types.LongType.get()), Types.NestedField.optional(3, "parent_id", Types.LongType.get()), Types.NestedField.optional(4, "operation", Types.StringType.get()), Types.NestedField.optional(5, "manifest_list", Types.StringType.get()), Types.NestedField.optional(6, "summary", Types.MapType.ofRequired(7, 8, Types.StringType.get(), Types.StringType.get())));
    private final TableOperations ops;
    private final Table table;

    public SnapshotsTable(TableOperations ops, Table table) {
        this.ops = ops;
        this.table = table;
    }

    @Override
    Table table() {
        return this.table;
    }

    @Override
    String metadataTableName() {
        return "snapshots";
    }

    @Override
    public TableScan newScan() {
        return new SnapshotsTableScan();
    }

    @Override
    public String location() {
        return this.ops.current().file().location();
    }

    @Override
    public Schema schema() {
        return SNAPSHOT_SCHEMA;
    }

    private DataTask task(BaseTableScan scan) {
        return StaticDataTask.of(this.ops.current().file(), this.ops.current().snapshots(), SnapshotsTable::snapshotToRow);
    }

    private static StaticDataTask.Row snapshotToRow(Snapshot snap) {
        return StaticDataTask.Row.of(snap.timestampMillis() * 1000L, snap.snapshotId(), snap.parentId(), snap.operation(), snap.manifestListLocation(), snap.summary());
    }

    private class SnapshotsTableScan
    extends StaticTableScan {
        SnapshotsTableScan() {
            super(SnapshotsTable.this.ops, SnapshotsTable.this.table, SNAPSHOT_SCHEMA, x$0 -> SnapshotsTable.this.task(x$0));
        }
    }
}

