/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.shaded.com.google.common.base.MoreObjects;
import org.apache.iceberg.shaded.com.google.common.base.Objects;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.shaded.com.google.common.collect.Iterables;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.PropertyUtil;

public class TableMetadata {
    static final int TABLE_FORMAT_VERSION = 1;
    static final int INITIAL_SPEC_ID = 0;
    private final TableOperations ops;
    private final InputFile file;
    private final String uuid;
    private final String location;
    private final long lastUpdatedMillis;
    private final int lastColumnId;
    private final Schema schema;
    private final int defaultSpecId;
    private final List<PartitionSpec> specs;
    private final Map<String, String> properties;
    private final long currentSnapshotId;
    private final List<Snapshot> snapshots;
    private final Map<Long, Snapshot> snapshotsById;
    private final Map<Integer, PartitionSpec> specsById;
    private final List<HistoryEntry> snapshotLog;

    public static TableMetadata newTableMetadata(TableOperations ops, Schema schema, PartitionSpec spec, String location) {
        return TableMetadata.newTableMetadata(ops, schema, spec, location, ImmutableMap.of());
    }

    public static TableMetadata newTableMetadata(TableOperations ops, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        AtomicInteger lastColumnId = new AtomicInteger(0);
        Schema freshSchema = TypeUtil.assignFreshIds(schema, lastColumnId::incrementAndGet);
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor(freshSchema).withSpecId(0);
        for (PartitionField field : spec.fields()) {
            String sourceName = schema.findColumnName(field.sourceId());
            specBuilder.add(freshSchema.findField(sourceName).fieldId(), field.name(), field.transform().toString());
        }
        PartitionSpec freshSpec = specBuilder.build();
        return new TableMetadata(ops, null, UUID.randomUUID().toString(), location, System.currentTimeMillis(), lastColumnId.get(), freshSchema, 0, ImmutableList.of(freshSpec), ImmutableMap.copyOf(properties), -1L, ImmutableList.of(), ImmutableList.of());
    }

    TableMetadata(TableOperations ops, InputFile file, String uuid, String location, long lastUpdatedMillis, int lastColumnId, Schema schema, int defaultSpecId, List<PartitionSpec> specs, Map<String, String> properties, long currentSnapshotId, List<Snapshot> snapshots, List<HistoryEntry> snapshotLog) {
        this.ops = ops;
        this.file = file;
        this.uuid = uuid;
        this.location = location;
        this.lastUpdatedMillis = lastUpdatedMillis;
        this.lastColumnId = lastColumnId;
        this.schema = schema;
        this.specs = specs;
        this.defaultSpecId = defaultSpecId;
        this.properties = properties;
        this.currentSnapshotId = currentSnapshotId;
        this.snapshots = snapshots;
        this.snapshotLog = snapshotLog;
        this.snapshotsById = TableMetadata.indexSnapshots(snapshots);
        this.specsById = TableMetadata.indexSpecs(specs);
        HistoryEntry last = null;
        for (HistoryEntry logEntry : snapshotLog) {
            if (last != null) {
                Preconditions.checkArgument(logEntry.timestampMillis() - last.timestampMillis() >= 0L, "[BUG] Expected sorted snapshot log entries.");
            }
            last = logEntry;
        }
        Preconditions.checkArgument(currentSnapshotId < 0L || this.snapshotsById.containsKey(currentSnapshotId), "Invalid table metadata: Cannot find current version");
    }

    public InputFile file() {
        return this.file;
    }

    public String uuid() {
        return this.uuid;
    }

    public long lastUpdatedMillis() {
        return this.lastUpdatedMillis;
    }

    public int lastColumnId() {
        return this.lastColumnId;
    }

    public Schema schema() {
        return this.schema;
    }

    public PartitionSpec spec() {
        return this.specsById.get(this.defaultSpecId);
    }

    public PartitionSpec spec(int id) {
        return this.specsById.get(id);
    }

    public List<PartitionSpec> specs() {
        return this.specs;
    }

    public Map<Integer, PartitionSpec> specsById() {
        return this.specsById;
    }

    public int defaultSpecId() {
        return this.defaultSpecId;
    }

    public String location() {
        return this.location;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public String property(String property, String defaultValue) {
        return this.properties.getOrDefault(property, defaultValue);
    }

    public boolean propertyAsBoolean(String property, boolean defaultValue) {
        return PropertyUtil.propertyAsBoolean(this.properties, property, defaultValue);
    }

    public int propertyAsInt(String property, int defaultValue) {
        return PropertyUtil.propertyAsInt(this.properties, property, defaultValue);
    }

    public long propertyAsLong(String property, long defaultValue) {
        return PropertyUtil.propertyAsLong(this.properties, property, defaultValue);
    }

    public Snapshot snapshot(long snapshotId) {
        return this.snapshotsById.get(snapshotId);
    }

    public Snapshot currentSnapshot() {
        return this.snapshotsById.get(this.currentSnapshotId);
    }

    public List<Snapshot> snapshots() {
        return this.snapshots;
    }

    public List<HistoryEntry> snapshotLog() {
        return this.snapshotLog;
    }

    public TableMetadata withUUID() {
        if (this.uuid != null) {
            return this;
        }
        return new TableMetadata(this.ops, null, UUID.randomUUID().toString(), this.location, this.lastUpdatedMillis, this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog);
    }

    public TableMetadata updateTableLocation(String newLocation) {
        return new TableMetadata(this.ops, null, this.uuid, newLocation, System.currentTimeMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog);
    }

    public TableMetadata updateSchema(Schema newSchema, int newLastColumnId) {
        PartitionSpec.checkCompatibility(this.spec(), newSchema);
        List<PartitionSpec> updatedSpecs = Lists.transform(this.specs, spec -> TableMetadata.updateSpecSchema(newSchema, spec));
        return new TableMetadata(this.ops, null, this.uuid, this.location, System.currentTimeMillis(), newLastColumnId, newSchema, this.defaultSpecId, updatedSpecs, this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog);
    }

    public TableMetadata updatePartitionSpec(PartitionSpec newPartitionSpec) {
        PartitionSpec.checkCompatibility(newPartitionSpec, this.schema);
        int newDefaultSpecId = 0;
        for (PartitionSpec spec : this.specs) {
            if (newPartitionSpec.compatibleWith(spec)) {
                newDefaultSpecId = spec.specId();
                break;
            }
            if (newDefaultSpecId > spec.specId()) continue;
            newDefaultSpecId = spec.specId() + 1;
        }
        Preconditions.checkArgument(this.defaultSpecId != newDefaultSpecId, "Cannot set default partition spec to the current default");
        ImmutableCollection.Builder builder = ImmutableList.builder().addAll(this.specs);
        if (!this.specsById.containsKey(newDefaultSpecId)) {
            ((ImmutableList.Builder)builder).add(TableMetadata.freshSpec(newDefaultSpecId, this.schema, newPartitionSpec));
        }
        return new TableMetadata(this.ops, null, this.uuid, this.location, System.currentTimeMillis(), this.lastColumnId, this.schema, newDefaultSpecId, (List<PartitionSpec>)((Object)((ImmutableList.Builder)builder).build()), this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog);
    }

    public TableMetadata addStagedSnapshot(Snapshot snapshot) {
        ImmutableCollection newSnapshots = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.snapshots)).add(snapshot)).build();
        return new TableMetadata(this.ops, null, this.uuid, this.location, snapshot.timestampMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.properties, this.currentSnapshotId, (List<Snapshot>)((Object)newSnapshots), this.snapshotLog);
    }

    public TableMetadata replaceCurrentSnapshot(Snapshot snapshot) {
        ImmutableCollection newSnapshots = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.snapshots)).add(snapshot)).build();
        ImmutableCollection newSnapshotLog = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.snapshotLog)).add(new SnapshotLogEntry(snapshot.timestampMillis(), snapshot.snapshotId()))).build();
        return new TableMetadata(this.ops, null, this.uuid, this.location, snapshot.timestampMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.properties, snapshot.snapshotId(), (List<Snapshot>)((Object)newSnapshots), (List<HistoryEntry>)((Object)newSnapshotLog));
    }

    public TableMetadata removeSnapshotsIf(Predicate<Snapshot> removeIf) {
        ArrayList<Snapshot> filtered = Lists.newArrayListWithExpectedSize(this.snapshots.size());
        for (Snapshot snapshot : this.snapshots) {
            if (snapshot.snapshotId() != this.currentSnapshotId && removeIf.test(snapshot)) continue;
            filtered.add(snapshot);
        }
        HashSet validIds = Sets.newHashSet(Iterables.transform(filtered, Snapshot::snapshotId));
        ArrayList<HistoryEntry> newSnapshotLog = Lists.newArrayList();
        for (HistoryEntry logEntry : this.snapshotLog) {
            if (validIds.contains(logEntry.snapshotId())) {
                newSnapshotLog.add(logEntry);
                continue;
            }
            newSnapshotLog.clear();
        }
        return new TableMetadata(this.ops, null, this.uuid, this.location, System.currentTimeMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.properties, this.currentSnapshotId, filtered, ImmutableList.copyOf(newSnapshotLog));
    }

    public TableMetadata rollbackTo(Snapshot snapshot) {
        ValidationException.check(this.snapshotsById.containsKey(snapshot.snapshotId()), "Cannot set current snapshot to unknown: %s", snapshot.snapshotId());
        long nowMillis = System.currentTimeMillis();
        ImmutableCollection newSnapshotLog = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.snapshotLog)).add(new SnapshotLogEntry(nowMillis, snapshot.snapshotId()))).build();
        return new TableMetadata(this.ops, null, this.uuid, this.location, nowMillis, this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.properties, snapshot.snapshotId(), this.snapshots, (List<HistoryEntry>)((Object)newSnapshotLog));
    }

    public TableMetadata replaceProperties(Map<String, String> newProperties) {
        ValidationException.check(newProperties != null, "Cannot set properties to null", new Object[0]);
        return new TableMetadata(this.ops, null, this.uuid, this.location, System.currentTimeMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, newProperties, this.currentSnapshotId, this.snapshots, this.snapshotLog);
    }

    public TableMetadata removeSnapshotLogEntries(Set<Long> snapshotIds) {
        ArrayList<HistoryEntry> newSnapshotLog = Lists.newArrayList();
        for (HistoryEntry logEntry : this.snapshotLog) {
            if (snapshotIds.contains(logEntry.snapshotId())) continue;
            newSnapshotLog.add(logEntry);
        }
        ValidationException.check(this.currentSnapshotId < 0L || ((HistoryEntry)Iterables.getLast(newSnapshotLog)).snapshotId() == this.currentSnapshotId, "Cannot set invalid snapshot log: latest entry is not the current snapshot", new Object[0]);
        return new TableMetadata(this.ops, null, this.uuid, this.location, System.currentTimeMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.properties, this.currentSnapshotId, this.snapshots, newSnapshotLog);
    }

    public TableMetadata buildReplacement(Schema updatedSchema, PartitionSpec updatedPartitionSpec, Map<String, String> updatedProperties) {
        AtomicInteger nextLastColumnId = new AtomicInteger(0);
        Schema freshSchema = TypeUtil.assignFreshIds(updatedSchema, nextLastColumnId::incrementAndGet);
        int nextSpecId = 0;
        for (Integer specId : this.specsById.keySet()) {
            if (nextSpecId > specId) continue;
            nextSpecId = specId + 1;
        }
        PartitionSpec freshSpec = TableMetadata.freshSpec(nextSpecId, freshSchema, updatedPartitionSpec);
        int specId = nextSpecId;
        for (PartitionSpec spec : this.specs) {
            if (!freshSpec.compatibleWith(spec)) continue;
            specId = spec.specId();
            break;
        }
        ImmutableCollection.Builder builder = ImmutableList.builder().addAll(this.specs);
        if (!this.specsById.containsKey(specId)) {
            ((ImmutableList.Builder)builder).add(freshSpec);
        }
        HashMap<String, String> newProperties = Maps.newHashMap();
        newProperties.putAll(this.properties);
        newProperties.putAll(updatedProperties);
        return new TableMetadata(this.ops, null, this.uuid, this.location, System.currentTimeMillis(), nextLastColumnId.get(), freshSchema, specId, (List<PartitionSpec>)((Object)((ImmutableList.Builder)builder).build()), ImmutableMap.copyOf(newProperties), -1L, this.snapshots, ImmutableList.of());
    }

    public TableMetadata updateLocation(String newLocation) {
        return new TableMetadata(this.ops, null, this.uuid, newLocation, System.currentTimeMillis(), this.lastColumnId, this.schema, this.defaultSpecId, this.specs, this.properties, this.currentSnapshotId, this.snapshots, this.snapshotLog);
    }

    private static PartitionSpec updateSpecSchema(Schema schema, PartitionSpec partitionSpec) {
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor(schema).withSpecId(partitionSpec.specId());
        for (PartitionField field : partitionSpec.fields()) {
            specBuilder.add(field.sourceId(), field.name(), field.transform().toString());
        }
        return specBuilder.build();
    }

    private static PartitionSpec freshSpec(int specId, Schema schema, PartitionSpec partitionSpec) {
        PartitionSpec.Builder specBuilder = PartitionSpec.builderFor(schema).withSpecId(specId);
        for (PartitionField field : partitionSpec.fields()) {
            String sourceName = partitionSpec.schema().findColumnName(field.sourceId());
            specBuilder.add(schema.findField(sourceName).fieldId(), field.name(), field.transform().toString());
        }
        return specBuilder.build();
    }

    private static Map<Long, Snapshot> indexSnapshots(List<Snapshot> snapshots) {
        ImmutableMap.Builder<Long, Snapshot> builder = ImmutableMap.builder();
        for (Snapshot version : snapshots) {
            builder.put(version.snapshotId(), version);
        }
        return builder.build();
    }

    private static Map<Integer, PartitionSpec> indexSpecs(List<PartitionSpec> specs) {
        ImmutableMap.Builder<Integer, PartitionSpec> builder = ImmutableMap.builder();
        for (PartitionSpec spec : specs) {
            builder.put(spec.specId(), spec);
        }
        return builder.build();
    }

    public static class SnapshotLogEntry
    implements HistoryEntry {
        private final long timestampMillis;
        private final long snapshotId;

        SnapshotLogEntry(long timestampMillis, long snapshotId) {
            this.timestampMillis = timestampMillis;
            this.snapshotId = snapshotId;
        }

        @Override
        public long timestampMillis() {
            return this.timestampMillis;
        }

        @Override
        public long snapshotId() {
            return this.snapshotId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SnapshotLogEntry that = (SnapshotLogEntry)other;
            return this.timestampMillis == that.timestampMillis && this.snapshotId == that.snapshotId;
        }

        public int hashCode() {
            return Objects.hashCode(this.timestampMillis, this.snapshotId);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("timestampMillis", this.timestampMillis).add("snapshotId", this.snapshotId).toString();
        }
    }
}

