/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseTransaction;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;

public final class Transactions {
    private Transactions() {
    }

    public static Transaction createOrReplaceTableTransaction(TableOperations ops, TableMetadata start) {
        return new BaseTransaction(ops, BaseTransaction.TransactionType.CREATE_OR_REPLACE_TABLE, start);
    }

    public static Transaction replaceTableTransaction(TableOperations ops, TableMetadata start) {
        return new BaseTransaction(ops, BaseTransaction.TransactionType.REPLACE_TABLE, start);
    }

    public static Transaction createTableTransaction(TableOperations ops, TableMetadata start) {
        Preconditions.checkArgument(ops.current() == null, "Cannot start create table transaction: table already exists");
        return new BaseTransaction(ops, BaseTransaction.TransactionType.CREATE_TABLE, start);
    }

    public static Transaction newTransaction(TableOperations ops) {
        return new BaseTransaction(ops, BaseTransaction.TransactionType.SIMPLE, ops.refresh());
    }
}

