/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.AvroFileAppender;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.GenericAvroReader;
import org.apache.iceberg.avro.GenericAvroWriter;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.ProjectionDatumReader;
import org.apache.iceberg.avro.UUIDConversion;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.org.apache.avro.Conversions;
import org.apache.iceberg.shaded.org.apache.avro.LogicalTypes;
import org.apache.iceberg.shaded.org.apache.avro.file.CodecFactory;
import org.apache.iceberg.shaded.org.apache.avro.generic.GenericData;
import org.apache.iceberg.shaded.org.apache.avro.io.DatumReader;
import org.apache.iceberg.shaded.org.apache.avro.io.DatumWriter;
import org.apache.iceberg.shaded.org.apache.avro.specific.SpecificData;

public class Avro {
    private static final GenericData DEFAULT_MODEL = new SpecificData();

    private Avro() {
    }

    public static WriteBuilder write(OutputFile file) {
        return new WriteBuilder(file);
    }

    public static ReadBuilder read(InputFile file) {
        return new ReadBuilder(file);
    }

    static {
        LogicalTypes.register("map", schema -> LogicalMap.get());
        DEFAULT_MODEL.addLogicalTypeConversion(new Conversions.DecimalConversion());
        DEFAULT_MODEL.addLogicalTypeConversion(new UUIDConversion());
    }

    public static class ReadBuilder {
        private final ClassLoader defaultLoader = Thread.currentThread().getContextClassLoader();
        private final InputFile file;
        private final Map<String, String> renames = Maps.newLinkedHashMap();
        private boolean reuseContainers = false;
        private Schema schema = null;
        private Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumReader<?>> createReaderFunc = readSchema -> {
            GenericAvroReader reader = new GenericAvroReader((org.apache.iceberg.shaded.org.apache.avro.Schema)readSchema);
            reader.setClassLoader(this.defaultLoader);
            return reader;
        };
        private Long start = null;
        private Long length = null;

        private ReadBuilder(InputFile file) {
            Preconditions.checkNotNull(file, "Input file cannot be null");
            this.file = file;
        }

        public ReadBuilder createReaderFunc(Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumReader<?>> readerFunction) {
            this.createReaderFunc = readerFunction;
            return this;
        }

        public ReadBuilder split(long newStart, long newLength) {
            this.start = newStart;
            this.length = newLength;
            return this;
        }

        public ReadBuilder project(Schema projectedSchema) {
            this.schema = projectedSchema;
            return this;
        }

        public ReadBuilder reuseContainers() {
            this.reuseContainers = true;
            return this;
        }

        public ReadBuilder reuseContainers(boolean shouldReuse) {
            this.reuseContainers = shouldReuse;
            return this;
        }

        public ReadBuilder rename(String fullName, String newName) {
            this.renames.put(fullName, newName);
            return this;
        }

        public <D> AvroIterable<D> build() {
            Preconditions.checkNotNull(this.schema, "Schema is required");
            return new AvroIterable(this.file, new ProjectionDatumReader(this.createReaderFunc, this.schema, this.renames), this.start, this.length, this.reuseContainers);
        }
    }

    public static class WriteBuilder {
        private final OutputFile file;
        private Schema schema = null;
        private String name = "table";
        private Map<String, String> config = Maps.newHashMap();
        private Map<String, String> metadata = Maps.newLinkedHashMap();
        private Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumWriter<?>> createWriterFunc = GenericAvroWriter::new;
        private boolean overwrite;

        private WriteBuilder(OutputFile file) {
            this.file = file;
        }

        public WriteBuilder forTable(Table table) {
            this.schema(table.schema());
            this.setAll(table.properties());
            return this;
        }

        public WriteBuilder schema(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public WriteBuilder named(String newName) {
            this.name = newName;
            return this;
        }

        public WriteBuilder createWriterFunc(Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumWriter<?>> writerFunction) {
            this.createWriterFunc = writerFunction;
            return this;
        }

        public WriteBuilder set(String property, String value) {
            this.config.put(property, value);
            return this;
        }

        public WriteBuilder setAll(Map<String, String> properties) {
            this.config.putAll(properties);
            return this;
        }

        public WriteBuilder meta(String property, String value) {
            this.metadata.put(property, value);
            return this;
        }

        public WriteBuilder meta(Map<String, String> properties) {
            this.metadata.putAll(properties);
            return this;
        }

        public WriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public WriteBuilder overwrite(boolean enabled) {
            this.overwrite = enabled;
            return this;
        }

        private CodecFactory codec() {
            String codec = this.config.getOrDefault("write.avro.compression-codec", "gzip");
            try {
                return CodecName.valueOf(codec.toUpperCase(Locale.ENGLISH)).get();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unsupported compression codec: " + codec);
            }
        }

        public <D> FileAppender<D> build() throws IOException {
            Preconditions.checkNotNull(this.schema, "Schema is required");
            Preconditions.checkNotNull(this.name, "Table name is required and cannot be null");
            this.meta("iceberg.schema", SchemaParser.toJson(this.schema));
            return new AvroFileAppender(AvroSchemaUtil.convert(this.schema, this.name), this.file, this.createWriterFunc, this.codec(), this.metadata, this.overwrite);
        }
    }

    private static enum CodecName {
        UNCOMPRESSED(CodecFactory.nullCodec()),
        SNAPPY(CodecFactory.snappyCodec()),
        GZIP(CodecFactory.deflateCodec(9)),
        LZ4(null),
        BROTLI(null),
        ZSTD(null);

        private CodecFactory avroCodec;

        private CodecName(CodecFactory avroCodec) {
            this.avroCodec = avroCodec;
        }

        public CodecFactory get() {
            Preconditions.checkArgument(this.avroCodec != null, "Missing implementation for codec %s", (Object)this);
            return this.avroCodec;
        }
    }
}

