/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.io.InputStream;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.io.DelegatingInputStream;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.shaded.org.apache.avro.file.SeekableInput;

class AvroIO {
    private static final Class<?> fsDataInputStreamClass = DynClasses.builder().impl("org.apache.hadoop.fs.FSDataInputStream").orNull().build();
    private static final boolean relocated = "org.apache.iceberg.shaded.org.apache.avro.file.SeekableInput".equals(SeekableInput.class.getName());
    private static final DynConstructors.Ctor<SeekableInput> avroFsInputCtor = !relocated && fsDataInputStreamClass != null ? DynConstructors.builder(SeekableInput.class).impl("org.apache.hadoop.fs.AvroFSInput", fsDataInputStreamClass, Long.TYPE).build() : null;

    private AvroIO() {
    }

    static SeekableInput stream(SeekableInputStream stream, long length) {
        if (stream instanceof DelegatingInputStream) {
            InputStream wrapped = ((DelegatingInputStream)((Object)stream)).getDelegate();
            if (avroFsInputCtor != null && fsDataInputStreamClass != null && fsDataInputStreamClass.isInstance(wrapped)) {
                return avroFsInputCtor.newInstance(wrapped, length);
            }
        }
        return new AvroInputStreamAdapter(stream, length);
    }

    private static class AvroInputStreamAdapter
    extends SeekableInputStream
    implements SeekableInput {
        private final SeekableInputStream stream;
        private final long length;

        AvroInputStreamAdapter(SeekableInputStream stream, long length) {
            this.stream = stream;
            this.length = length;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        @Override
        public void seek(long newPos) throws IOException {
            this.stream.seek(newPos);
        }

        @Override
        public long tell() throws IOException {
            return this.getPos();
        }

        @Override
        public long length() throws IOException {
            return this.length;
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.stream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.stream.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.stream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }
    }
}

