/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.avro.ValueReaders;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.shaded.com.google.common.collect.MapMaker;
import org.apache.iceberg.shaded.org.apache.avro.LogicalType;
import org.apache.iceberg.shaded.org.apache.avro.LogicalTypes;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.shaded.org.apache.avro.io.DatumReader;
import org.apache.iceberg.shaded.org.apache.avro.io.Decoder;
import org.apache.iceberg.shaded.org.apache.avro.io.DecoderFactory;
import org.apache.iceberg.shaded.org.apache.avro.io.ResolvingDecoder;

class GenericAvroReader<T>
implements DatumReader<T> {
    private static final ThreadLocal<Map<Schema, Map<Schema, ResolvingDecoder>>> DECODER_CACHES = ThreadLocal.withInitial(() -> new MapMaker().weakKeys().makeMap());
    private final Schema readSchema;
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();
    private Schema fileSchema = null;
    private ValueReader<T> reader = null;

    GenericAvroReader(Schema readSchema) {
        this.readSchema = readSchema;
    }

    private void initReader() {
        this.reader = (ValueReader)AvroSchemaVisitor.visit(this.readSchema, new ReadBuilder(this.loader));
    }

    @Override
    public void setSchema(Schema schema) {
        this.fileSchema = Schema.applyAliases(schema, this.readSchema);
        this.initReader();
    }

    public void setClassLoader(ClassLoader newClassLoader) {
        this.loader = newClassLoader;
    }

    @Override
    public T read(T reuse, Decoder decoder) throws IOException {
        ResolvingDecoder resolver = this.resolve(decoder);
        T value = this.reader.read(resolver, reuse);
        resolver.drain();
        return value;
    }

    private ResolvingDecoder resolve(Decoder decoder) throws IOException {
        Map<Schema, Map<Schema, ResolvingDecoder>> cache = DECODER_CACHES.get();
        Map fileSchemaToResolver = cache.computeIfAbsent(this.readSchema, k -> new HashMap());
        ResolvingDecoder resolver = (ResolvingDecoder)fileSchemaToResolver.get(this.fileSchema);
        if (resolver == null) {
            resolver = this.newResolver();
            fileSchemaToResolver.put(this.fileSchema, resolver);
        }
        resolver.configure(decoder);
        return resolver;
    }

    private ResolvingDecoder newResolver() {
        try {
            return DecoderFactory.get().resolvingDecoder(this.fileSchema, this.readSchema, null);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static class ReadBuilder
    extends AvroSchemaVisitor<ValueReader<?>> {
        private final ClassLoader loader;

        private ReadBuilder(ClassLoader loader) {
            this.loader = loader;
        }

        @Override
        public ValueReader<?> record(Schema record, List<String> names, List<ValueReader<?>> fields) {
            try {
                Class recordClass = DynClasses.builder().loader(this.loader).impl(record.getFullName()).buildChecked();
                if (IndexedRecord.class.isAssignableFrom(recordClass)) {
                    return ValueReaders.record(fields, recordClass, record);
                }
                return ValueReaders.record(fields, record);
            }
            catch (ClassNotFoundException e) {
                return ValueReaders.record(fields, record);
            }
        }

        @Override
        public ValueReader<?> union(Schema union, List<ValueReader<?>> options) {
            return ValueReaders.union(options);
        }

        @Override
        public ValueReader<?> array(Schema array, ValueReader<?> elementReader) {
            if (array.getLogicalType() instanceof LogicalMap) {
                ValueReaders.StructReader keyValueReader = (ValueReaders.StructReader)elementReader;
                ValueReader<?> keyReader = keyValueReader.reader(0);
                ValueReader<?> valueReader = keyValueReader.reader(1);
                if (keyReader == ValueReaders.utf8s()) {
                    return ValueReaders.arrayMap(ValueReaders.strings(), valueReader);
                }
                return ValueReaders.arrayMap(keyReader, valueReader);
            }
            return ValueReaders.array(elementReader);
        }

        @Override
        public ValueReader<?> map(Schema map, ValueReader<?> valueReader) {
            return ValueReaders.map(ValueReaders.strings(), valueReader);
        }

        @Override
        public ValueReader<?> primitive(Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return ValueReaders.ints();
                    }
                    case "timestamp-millis": {
                        ValueReader<Long> longs = ValueReaders.longs();
                        return (decoder, ignored) -> (Long)longs.read(decoder, null) * 1000L;
                    }
                    case "timestamp-micros": {
                        return ValueReaders.longs();
                    }
                    case "decimal": {
                        ValueReader<byte[]> inner;
                        switch (primitive.getType()) {
                            case FIXED: {
                                inner = ValueReaders.fixed(primitive.getFixedSize());
                                break;
                            }
                            case BYTES: {
                                inner = ValueReaders.bytes();
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid primitive type for decimal: " + (Object)((Object)primitive.getType()));
                            }
                        }
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return ValueReaders.decimal(inner, decimal.getScale());
                    }
                    case "uuid": {
                        return ValueReaders.uuids();
                    }
                }
                throw new IllegalArgumentException("Unknown logical type: " + logicalType);
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueReaders.nulls();
                }
                case BOOLEAN: {
                    return ValueReaders.booleans();
                }
                case INT: {
                    return ValueReaders.ints();
                }
                case LONG: {
                    return ValueReaders.longs();
                }
                case FLOAT: {
                    return ValueReaders.floats();
                }
                case DOUBLE: {
                    return ValueReaders.doubles();
                }
                case STRING: {
                    return ValueReaders.utf8s();
                }
                case FIXED: {
                    return ValueReaders.fixed(primitive);
                }
                case BYTES: {
                    return ValueReaders.byteBuffers();
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }
    }
}

