/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.org.apache.avro.LogicalType;
import org.apache.iceberg.shaded.org.apache.avro.Schema;

public class LogicalMap
extends LogicalType {
    static final String NAME = "map";
    private static final LogicalMap INSTANCE = new LogicalMap();

    static LogicalMap get() {
        return INSTANCE;
    }

    private LogicalMap() {
        super(NAME);
    }

    @Override
    public void validate(Schema schema) {
        super.validate(schema);
        Preconditions.checkArgument(schema.getType() == Schema.Type.ARRAY, "Invalid type for map, must be an array: %s", (Object)schema);
        Preconditions.checkArgument(AvroSchemaUtil.isKeyValueSchema(schema.getElementType()), "Invalid key-value record: %s", (Object)schema.getElementType());
    }
}

