/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.shaded.org.apache.avro.io.DatumReader;
import org.apache.iceberg.shaded.org.apache.avro.io.Decoder;
import org.apache.iceberg.types.TypeUtil;

public class ProjectionDatumReader<D>
implements DatumReader<D> {
    private final Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumReader<?>> getReader;
    private final Schema expectedSchema;
    private final Map<String, String> renames;
    private org.apache.iceberg.shaded.org.apache.avro.Schema readSchema = null;
    private org.apache.iceberg.shaded.org.apache.avro.Schema fileSchema = null;
    private DatumReader<D> wrapped = null;

    public ProjectionDatumReader(Function<org.apache.iceberg.shaded.org.apache.avro.Schema, DatumReader<?>> getReader, Schema expectedSchema, Map<String, String> renames) {
        this.getReader = getReader;
        this.expectedSchema = expectedSchema;
        this.renames = renames;
    }

    @Override
    public void setSchema(org.apache.iceberg.shaded.org.apache.avro.Schema newFileSchema) {
        this.fileSchema = newFileSchema;
        Set<Integer> projectedIds = TypeUtil.getProjectedIds(this.expectedSchema);
        org.apache.iceberg.shaded.org.apache.avro.Schema prunedSchema = AvroSchemaUtil.pruneColumns(newFileSchema, projectedIds);
        this.readSchema = AvroSchemaUtil.buildAvroProjection(prunedSchema, this.expectedSchema, this.renames);
        this.wrapped = this.newDatumReader();
    }

    @Override
    public D read(D reuse, Decoder in) throws IOException {
        return this.wrapped.read(reuse, in);
    }

    private DatumReader<D> newDatumReader() {
        DatumReader<?> reader = this.getReader.apply(this.readSchema);
        reader.setSchema(this.fileSchema);
        return reader;
    }
}

