/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.avro.Schema;

class PruneColumns
extends AvroSchemaVisitor<Schema> {
    private final Set<Integer> selectedIds;

    PruneColumns(Set<Integer> selectedIds) {
        this.selectedIds = selectedIds;
    }

    public Schema rootSchema(Schema record) {
        Schema result = PruneColumns.visit(record, this);
        if (result != null) {
            return result;
        }
        return PruneColumns.copyRecord(record, ImmutableList.of());
    }

    @Override
    public Schema record(Schema record, List<String> names, List<Schema> fields) {
        ArrayList<Schema.Field> filteredFields = Lists.newArrayListWithExpectedSize(fields.size());
        boolean hasChange = false;
        for (Schema.Field field : record.getFields()) {
            int fieldId = AvroSchemaUtil.getFieldId(field);
            Schema fieldSchema = fields.get(field.pos());
            if (this.selectedIds.contains(fieldId)) {
                filteredFields.add(PruneColumns.copyField(field, field.schema()));
                continue;
            }
            if (fieldSchema == null) continue;
            hasChange = true;
            filteredFields.add(PruneColumns.copyField(field, fieldSchema));
        }
        if (hasChange) {
            return PruneColumns.copyRecord(record, filteredFields);
        }
        if (filteredFields.size() == record.getFields().size()) {
            return record;
        }
        if (!filteredFields.isEmpty()) {
            return PruneColumns.copyRecord(record, filteredFields);
        }
        return null;
    }

    @Override
    public Schema union(Schema union, List<Schema> options) {
        Preconditions.checkState(AvroSchemaUtil.isOptionSchema(union), "Invalid schema: non-option unions are not supported: %s", (Object)union);
        Schema pruned = null;
        if (options.get(0) != null) {
            pruned = options.get(0);
        } else if (options.get(1) != null) {
            pruned = options.get(1);
        }
        if (pruned != null) {
            if (pruned != AvroSchemaUtil.fromOption(union)) {
                return AvroSchemaUtil.toOption(pruned);
            }
            return union;
        }
        return null;
    }

    @Override
    public Schema array(Schema array, Schema element) {
        if (array.getLogicalType() instanceof LogicalMap) {
            Schema keyValue = array.getElementType();
            int keyId = AvroSchemaUtil.getFieldId(keyValue.getField("key"));
            int valueId = AvroSchemaUtil.getFieldId(keyValue.getField("value"));
            if (this.selectedIds.contains(keyId) || this.selectedIds.contains(valueId)) {
                return array;
            }
            if (element != null) {
                if (keyValue.getField("value").schema() != element.getField("value").schema()) {
                    return AvroSchemaUtil.createMap(keyId, keyValue.getField("key").schema(), valueId, element.getField("value").schema());
                }
                return array;
            }
        } else {
            int elementId = AvroSchemaUtil.getElementId(array);
            if (this.selectedIds.contains(elementId)) {
                return array;
            }
            if (element != null) {
                if (element != array.getElementType()) {
                    return Schema.createArray(element);
                }
                return array;
            }
        }
        return null;
    }

    @Override
    public Schema map(Schema map, Schema value) {
        int keyId = AvroSchemaUtil.getKeyId(map);
        int valueId = AvroSchemaUtil.getValueId(map);
        if (this.selectedIds.contains(keyId) || this.selectedIds.contains(valueId)) {
            return map;
        }
        if (value != null) {
            if (value != map.getValueType()) {
                return Schema.createMap(value);
            }
            return map;
        }
        return null;
    }

    @Override
    public Schema primitive(Schema primitive) {
        return null;
    }

    private static Schema copyRecord(Schema record, List<Schema.Field> newFields) {
        Schema copy = Schema.createRecord(record.getName(), record.getDoc(), record.getNamespace(), record.isError(), newFields);
        for (Map.Entry<String, Object> prop : record.getObjectProps().entrySet()) {
            copy.addProp(prop.getKey(), prop.getValue());
        }
        return copy;
    }

    private static Schema.Field copyField(Schema.Field field, Schema newSchema) {
        Schema.Field copy = new Schema.Field(field.name(), newSchema, field.doc(), field.defaultVal(), field.order());
        for (Map.Entry<String, Object> prop : field.getObjectProps().entrySet()) {
            copy.addProp(prop.getKey(), prop.getValue());
        }
        return copy;
    }
}

