/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;
import org.apache.iceberg.shaded.org.apache.avro.Conversion;
import org.apache.iceberg.shaded.org.apache.avro.LogicalType;
import org.apache.iceberg.shaded.org.apache.avro.LogicalTypes;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.generic.GenericData;
import org.apache.iceberg.shaded.org.apache.avro.generic.GenericFixed;

public class UUIDConversion
extends Conversion<UUID> {
    @Override
    public Class<UUID> getConvertedType() {
        return UUID.class;
    }

    @Override
    public String getLogicalTypeName() {
        return LogicalTypes.uuid().getName();
    }

    @Override
    public UUID fromFixed(GenericFixed value, Schema schema, LogicalType type) {
        ByteBuffer buffer = ByteBuffer.wrap(value.bytes());
        buffer.order(ByteOrder.BIG_ENDIAN);
        long mostSigBits = buffer.getLong();
        long leastSigBits = buffer.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }

    @Override
    public GenericFixed toFixed(UUID value, Schema schema, LogicalType type) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putLong(value.getMostSignificantBits());
        buffer.putLong(value.getLeastSignificantBits());
        return new GenericData.Fixed(schema, buffer.array());
    }
}

