/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.List;
import java.util.Set;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.shaded.com.google.common.collect.Sets;
import org.apache.iceberg.types.Types;

public class Binder {
    private Binder() {
    }

    public static Expression bind(Types.StructType struct, Expression expr, boolean caseSensitive) {
        return ExpressionVisitors.visit(expr, new BindVisitor(struct, caseSensitive));
    }

    static Expression bind(Types.StructType struct, Expression expr) {
        return Binder.bind(struct, expr, true);
    }

    public static Set<Integer> boundReferences(Types.StructType struct, List<Expression> exprs, boolean caseSensitive) {
        if (exprs == null) {
            return ImmutableSet.of();
        }
        ReferenceVisitor visitor = new ReferenceVisitor();
        for (Expression expr : exprs) {
            ExpressionVisitors.visit(Binder.bind(struct, expr, caseSensitive), visitor);
        }
        return visitor.references;
    }

    private static class ReferenceVisitor
    extends ExpressionVisitors.ExpressionVisitor<Set<Integer>> {
        private final Set<Integer> references = Sets.newHashSet();

        private ReferenceVisitor() {
        }

        @Override
        public Set<Integer> alwaysTrue() {
            return this.references;
        }

        @Override
        public Set<Integer> alwaysFalse() {
            return this.references;
        }

        @Override
        public Set<Integer> not(Set<Integer> result) {
            return this.references;
        }

        @Override
        public Set<Integer> and(Set<Integer> leftResult, Set<Integer> rightResult) {
            return this.references;
        }

        @Override
        public Set<Integer> or(Set<Integer> leftResult, Set<Integer> rightResult) {
            return this.references;
        }

        @Override
        public <T> Set<Integer> predicate(BoundPredicate<T> pred) {
            this.references.add(((BoundReference)pred.ref()).fieldId());
            return this.references;
        }
    }

    private static class BindVisitor
    extends ExpressionVisitors.ExpressionVisitor<Expression> {
        private final Types.StructType struct;
        private final boolean caseSensitive;

        private BindVisitor(Types.StructType struct, boolean caseSensitive) {
            this.struct = struct;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public Expression alwaysTrue() {
            return Expressions.alwaysTrue();
        }

        @Override
        public Expression alwaysFalse() {
            return Expressions.alwaysFalse();
        }

        @Override
        public Expression not(Expression result) {
            return Expressions.not(result);
        }

        @Override
        public Expression and(Expression leftResult, Expression rightResult) {
            return Expressions.and(leftResult, rightResult);
        }

        @Override
        public Expression or(Expression leftResult, Expression rightResult) {
            return Expressions.or(leftResult, rightResult);
        }

        @Override
        public <T> Expression predicate(BoundPredicate<T> pred) {
            throw new IllegalStateException("Found already bound predicate: " + pred);
        }

        @Override
        public <T> Expression predicate(UnboundPredicate<T> pred) {
            return pred.bind(this.struct, this.caseSensitive);
        }
    }
}

