/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFilesTable;
import org.apache.iceberg.HistoryTable;
import org.apache.iceberg.ManifestEntriesTable;
import org.apache.iceberg.ManifestsTable;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SnapshotsTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Tables;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopTableOperations;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableMap;

public class HadoopTables
implements Tables,
Configurable {
    private Configuration conf;

    public HadoopTables() {
        this(new Configuration());
    }

    public HadoopTables(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public Table load(String location) {
        TableOperations ops = this.newTableOps(location);
        if (ops.current() == null) {
            int hashIndex = location.lastIndexOf(35);
            if (hashIndex != -1 && location.length() - 1 != hashIndex) {
                String baseTable = location.substring(0, hashIndex);
                String metaTable = location.substring(hashIndex + 1);
                MetadataTableType type = MetadataTableType.from(metaTable);
                if (type != null) {
                    return this.loadMetadataTable(baseTable, type);
                }
                throw new NoSuchTableException("Table does not exist at location: " + location, new Object[0]);
            }
            throw new NoSuchTableException("Table does not exist at location: " + location, new Object[0]);
        }
        return new BaseTable(ops, location);
    }

    private Table loadMetadataTable(String location, MetadataTableType type) {
        TableOperations ops = this.newTableOps(location);
        if (ops.current() == null) {
            throw new NoSuchTableException("Table does not exist at location: " + location, new Object[0]);
        }
        BaseTable baseTable = new BaseTable(ops, location);
        switch (type) {
            case ENTRIES: {
                return new ManifestEntriesTable(ops, baseTable);
            }
            case FILES: {
                return new DataFilesTable(ops, baseTable);
            }
            case HISTORY: {
                return new HistoryTable(ops, baseTable);
            }
            case SNAPSHOTS: {
                return new SnapshotsTable(ops, baseTable);
            }
            case MANIFESTS: {
                return new ManifestsTable(ops, baseTable);
            }
        }
        throw new NoSuchTableException(String.format("Unknown metadata table type: %s for %s", new Object[]{type, location}), new Object[0]);
    }

    @Override
    public Table create(Schema schema, PartitionSpec spec, Map<String, String> properties, String location) {
        Preconditions.checkNotNull(schema, "A table schema is required");
        TableOperations ops = this.newTableOps(location);
        if (ops.current() != null) {
            throw new AlreadyExistsException("Table already exists at location: " + location, new Object[0]);
        }
        ImmutableMap<String, String> tableProps = properties == null ? ImmutableMap.of() : properties;
        PartitionSpec partitionSpec = spec == null ? PartitionSpec.unpartitioned() : spec;
        TableMetadata metadata = TableMetadata.newTableMetadata(ops, schema, partitionSpec, location, tableProps);
        ops.commit(null, metadata);
        return new BaseTable(ops, location);
    }

    private TableOperations newTableOps(String location) {
        return new HadoopTableOperations(new Path(location), this.conf);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

