/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mapping;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.shaded.com.google.common.base.Joiner;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableMap;

public class MappedFields {
    private final List<MappedField> fields;
    private final Map<String, Integer> nameToId;
    private final Map<Integer, MappedField> idToField;

    public static MappedFields of(MappedField ... fields) {
        return new MappedFields(ImmutableList.copyOf(fields));
    }

    public static MappedFields of(List<MappedField> fields) {
        return new MappedFields(fields);
    }

    private MappedFields(List<MappedField> fields) {
        this.fields = ImmutableList.copyOf(fields);
        this.nameToId = MappedFields.indexIds(fields);
        this.idToField = MappedFields.indexFields(fields);
    }

    public MappedField field(int id) {
        return this.idToField.get(id);
    }

    public Integer id(String name) {
        return this.nameToId.get(name);
    }

    public int size() {
        return this.fields.size();
    }

    private static Map<String, Integer> indexIds(List<MappedField> fields) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        fields.forEach(field -> field.names().forEach(name -> {
            Integer id = field.id();
            if (id != null) {
                builder.put(name, id);
            }
        }));
        return builder.build();
    }

    private static Map<Integer, MappedField> indexFields(List<MappedField> fields) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        fields.forEach(field -> {
            Integer id = field.id();
            if (id != null) {
                builder.put(id, field);
            }
        });
        return builder.build();
    }

    public List<MappedField> fields() {
        return this.fields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.fields.equals(((MappedFields)other).fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        return "[ " + Joiner.on(", ").join(this.fields) + " ]";
    }
}

