/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mapping;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.MappedFields;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.shaded.com.google.common.base.Joiner;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableList;

public class NameMapping {
    private static final Joiner DOT = Joiner.on('.');
    private final MappedFields mapping;
    private final Map<Integer, MappedField> fieldsById;
    private final Map<String, MappedField> fieldsByName;

    public static NameMapping of(MappedField ... fields) {
        return new NameMapping(MappedFields.of(ImmutableList.copyOf(fields)));
    }

    public static NameMapping of(List<MappedField> fields) {
        return new NameMapping(MappedFields.of(fields));
    }

    public static NameMapping of(MappedFields fields) {
        return new NameMapping(fields);
    }

    NameMapping(MappedFields mapping) {
        this.mapping = mapping;
        this.fieldsById = MappingUtil.indexById(mapping);
        this.fieldsByName = MappingUtil.indexByName(mapping);
    }

    public MappedField find(int id) {
        return this.fieldsById.get(id);
    }

    public MappedField find(String ... names) {
        return this.fieldsByName.get(DOT.join(names));
    }

    public MappedField find(List<String> names) {
        return this.fieldsByName.get(DOT.join(names));
    }

    public MappedFields asMappedFields() {
        return this.mapping;
    }

    public String toString() {
        if (this.mapping.fields().isEmpty()) {
            return "[]";
        }
        return "[\n  " + Joiner.on("\n  ").join(this.mapping.fields()) + "\n]";
    }
}

