/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ColumnIdMap;
import org.apache.iceberg.orc.OrcFileAppender;
import org.apache.iceberg.orc.OrcIterable;
import org.apache.iceberg.orc.OrcValueReader;
import org.apache.iceberg.orc.OrcValueWriter;
import org.apache.iceberg.orc.TypeConversion;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.org.apache.orc.OrcConf;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;

public class ORC {
    private static final String VECTOR_ROW_BATCH_SIZE = "iceberg.orc.vectorbatch.size";

    private ORC() {
    }

    public static WriteBuilder write(OutputFile file) {
        return new WriteBuilder(file);
    }

    public static ReadBuilder read(InputFile file) {
        return new ReadBuilder(file);
    }

    public static class ReadBuilder {
        private final InputFile file;
        private final Configuration conf;
        private Schema schema = null;
        private Long start = null;
        private Long length = null;
        private Function<Schema, OrcValueReader<?>> readerFunc;

        private ReadBuilder(InputFile file) {
            Preconditions.checkNotNull(file, "Input file cannot be null");
            this.file = file;
            this.conf = file instanceof HadoopInputFile ? new Configuration(((HadoopInputFile)file).getConf()) : new Configuration();
        }

        public ReadBuilder split(long newStart, long newLength) {
            this.start = newStart;
            this.length = newLength;
            return this;
        }

        public ReadBuilder schema(Schema projectSchema) {
            this.schema = projectSchema;
            return this;
        }

        public ReadBuilder caseSensitive(boolean caseSensitive) {
            OrcConf.IS_SCHEMA_EVOLUTION_CASE_SENSITIVE.setBoolean(this.conf, caseSensitive);
            return this;
        }

        public ReadBuilder config(String property, String value) {
            this.conf.set(property, value);
            return this;
        }

        public ReadBuilder createReaderFunc(Function<Schema, OrcValueReader<?>> readerFunction) {
            this.readerFunc = readerFunction;
            return this;
        }

        public <D> CloseableIterable<D> build() {
            Preconditions.checkNotNull(this.schema, "Schema is required");
            return new OrcIterable(this.file, this.conf, this.schema, this.start, this.length, this.readerFunc);
        }
    }

    public static class WriteBuilder {
        private final OutputFile file;
        private final Configuration conf;
        private Schema schema = null;
        private Function<TypeDescription, OrcValueWriter<?>> createWriterFunc;
        private Map<String, byte[]> metadata = new HashMap<String, byte[]>();

        private WriteBuilder(OutputFile file) {
            this.file = file;
            this.conf = file instanceof HadoopOutputFile ? new Configuration(((HadoopOutputFile)file).getConf()) : new Configuration();
        }

        public WriteBuilder metadata(String property, String value) {
            this.metadata.put(property, value.getBytes(StandardCharsets.UTF_8));
            return this;
        }

        public WriteBuilder config(String property, String value) {
            this.conf.set(property, value);
            return this;
        }

        public WriteBuilder createWriterFunc(Function<TypeDescription, OrcValueWriter<?>> writerFunction) {
            this.createWriterFunc = writerFunction;
            return this;
        }

        public WriteBuilder setAll(Map<String, String> properties) {
            properties.forEach((arg_0, arg_1) -> ((Configuration)this.conf).set(arg_0, arg_1));
            return this;
        }

        public WriteBuilder schema(Schema newSchema) {
            this.schema = newSchema;
            return this;
        }

        public WriteBuilder overwrite() {
            return this.overwrite(true);
        }

        public WriteBuilder overwrite(boolean enabled) {
            OrcConf.OVERWRITE_OUTPUT_FILE.setBoolean(this.conf, enabled);
            return this;
        }

        public <D> FileAppender<D> build() {
            Preconditions.checkNotNull(this.schema, "Schema is required");
            return new OrcFileAppender(TypeConversion.toOrc(this.schema, new ColumnIdMap()), this.file, this.createWriterFunc, this.conf, this.metadata, this.conf.getInt(ORC.VECTOR_ROW_BATCH_SIZE, 1024));
        }
    }
}

