/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.orc.ColumnIdMap;
import org.apache.iceberg.orc.OrcValueReader;
import org.apache.iceberg.orc.TypeConversion;
import org.apache.iceberg.orc.VectorizedRowBatchIterator;
import org.apache.iceberg.shaded.org.apache.orc.OrcFile;
import org.apache.iceberg.shaded.org.apache.orc.Reader;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

class OrcIterable<T>
extends CloseableGroup
implements CloseableIterable<T> {
    private final Configuration config;
    private final Schema schema;
    private final InputFile file;
    private final Long start;
    private final Long length;
    private final Function<Schema, OrcValueReader<?>> readerFunction;

    OrcIterable(InputFile file, Configuration config, Schema schema, Long start, Long length, Function<Schema, OrcValueReader<?>> readerFunction) {
        this.schema = schema;
        this.readerFunction = readerFunction;
        this.file = file;
        this.start = start;
        this.length = length;
        this.config = config;
    }

    @Override
    public Iterator<T> iterator() {
        return new OrcIterator(OrcIterable.newOrcIterator(this.file, TypeConversion.toOrc(this.schema, new ColumnIdMap()), this.start, this.length, OrcIterable.newFileReader(this.file, this.config)), this.readerFunction.apply(this.schema));
    }

    private static VectorizedRowBatchIterator newOrcIterator(InputFile file, TypeDescription readerSchema, Long start, Long length, Reader orcFileReader) {
        Reader.Options options = orcFileReader.options();
        if (start != null) {
            options.range(start, length);
        }
        options.schema(readerSchema);
        try {
            return new VectorizedRowBatchIterator(file.location(), readerSchema, orcFileReader.rows(options));
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to get ORC rows for file: %s", file);
        }
    }

    private static Reader newFileReader(InputFile file, Configuration config) {
        try {
            return OrcFile.createReader(new Path(file.location()), OrcFile.readerOptions(config));
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to open file: %s", file);
        }
    }

    private static class OrcIterator<T>
    implements Iterator<T> {
        private int nextRow;
        private VectorizedRowBatch current;
        private final VectorizedRowBatchIterator batchIter;
        private final OrcValueReader<T> reader;

        OrcIterator(VectorizedRowBatchIterator batchIter, OrcValueReader<T> reader) {
            this.batchIter = batchIter;
            this.reader = reader;
            this.current = null;
            this.nextRow = 0;
        }

        @Override
        public boolean hasNext() {
            return this.current != null && this.nextRow < this.current.size || this.batchIter.hasNext();
        }

        @Override
        public T next() {
            if (this.current == null || this.nextRow >= this.current.size) {
                this.current = this.batchIter.next();
                this.nextRow = 0;
            }
            return this.reader.read(this.current, this.nextRow++);
        }
    }
}

