/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.orc.ColumnIdMap;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class TypeConversion {
    public static TypeDescription toOrc(Schema schema, ColumnIdMap columnIds) {
        return TypeConversion.toOrc(null, schema.asStruct(), columnIds);
    }

    static TypeDescription toOrc(Integer fieldId, Type type, ColumnIdMap columnIds) {
        TypeDescription result;
        switch (type.typeId()) {
            case BOOLEAN: {
                result = TypeDescription.createBoolean();
                break;
            }
            case INTEGER: {
                result = TypeDescription.createInt();
                break;
            }
            case LONG: {
                result = TypeDescription.createLong();
                break;
            }
            case FLOAT: {
                result = TypeDescription.createFloat();
                break;
            }
            case DOUBLE: {
                result = TypeDescription.createDouble();
                break;
            }
            case DATE: {
                result = TypeDescription.createDate();
                break;
            }
            case TIME: {
                result = TypeDescription.createInt();
                break;
            }
            case TIMESTAMP: {
                result = TypeDescription.createTimestamp();
                break;
            }
            case STRING: {
                result = TypeDescription.createString();
                break;
            }
            case UUID: {
                result = TypeDescription.createBinary();
                break;
            }
            case FIXED: {
                result = TypeDescription.createBinary();
                break;
            }
            case BINARY: {
                result = TypeDescription.createBinary();
                break;
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)type;
                result = TypeDescription.createDecimal().withScale(decimal.scale()).withPrecision(decimal.precision());
                break;
            }
            case STRUCT: {
                result = TypeDescription.createStruct();
                for (Types.NestedField field : type.asStructType().fields()) {
                    result.addField(field.name(), TypeConversion.toOrc(field.fieldId(), field.type(), columnIds));
                }
                break;
            }
            case LIST: {
                Types.ListType list = (Types.ListType)type;
                result = TypeDescription.createList(TypeConversion.toOrc(list.elementId(), list.elementType(), columnIds));
                break;
            }
            case MAP: {
                Types.MapType map = (Types.MapType)type;
                TypeDescription key = TypeConversion.toOrc(map.keyId(), map.keyType(), columnIds);
                result = TypeDescription.createMap(key, TypeConversion.toOrc(map.valueId(), map.valueType(), columnIds));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled type " + (Object)((Object)type.typeId()));
            }
        }
        if (fieldId != null) {
            columnIds.put(result, fieldId);
        }
        return result;
    }

    public Schema fromOrc(TypeDescription schema, ColumnIdMap columnIds) {
        return new Schema(this.convertOrcToType(schema, columnIds).asStructType().fields());
    }

    Type convertOrcToType(TypeDescription schema, ColumnIdMap columnIds) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return Types.BooleanType.get();
            }
            case BYTE: 
            case SHORT: 
            case INT: {
                return Types.IntegerType.get();
            }
            case LONG: {
                return Types.LongType.get();
            }
            case FLOAT: {
                return Types.FloatType.get();
            }
            case DOUBLE: {
                return Types.DoubleType.get();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return Types.StringType.get();
            }
            case BINARY: {
                return Types.BinaryType.get();
            }
            case DATE: {
                return Types.DateType.get();
            }
            case TIMESTAMP: {
                return Types.TimestampType.withoutZone();
            }
            case DECIMAL: {
                return Types.DecimalType.of(schema.getPrecision(), schema.getScale());
            }
            case STRUCT: {
                List<String> fieldNames = schema.getFieldNames();
                List<TypeDescription> fieldTypes = schema.getChildren();
                ArrayList<Types.NestedField> fields = new ArrayList<Types.NestedField>(fieldNames.size());
                for (int c = 0; c < fieldNames.size(); ++c) {
                    String name = fieldNames.get(c);
                    TypeDescription type = fieldTypes.get(c);
                    fields.add(Types.NestedField.optional(columnIds.get(type), name, this.convertOrcToType(type, columnIds)));
                }
                return Types.StructType.of(fields);
            }
            case LIST: {
                TypeDescription child = schema.getChildren().get(0);
                return Types.ListType.ofOptional(columnIds.get(child), this.convertOrcToType(child, columnIds));
            }
            case MAP: {
                TypeDescription key = schema.getChildren().get(0);
                TypeDescription value = schema.getChildren().get(1);
                return Types.MapType.ofOptional(columnIds.get(key), columnIds.get(value), this.convertOrcToType(key, columnIds), this.convertOrcToType(value, columnIds));
            }
        }
        throw new IllegalArgumentException("Can't handle " + schema);
    }
}

