/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.iceberg.shaded.org.apache.orc.RecordReader;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

public class VectorizedRowBatchIterator
implements Iterator<VectorizedRowBatch>,
Closeable {
    private final String fileLocation;
    private final RecordReader rows;
    private final VectorizedRowBatch batch;
    private boolean advanced = false;

    VectorizedRowBatchIterator(String fileLocation, TypeDescription schema, RecordReader rows) {
        this.fileLocation = fileLocation;
        this.rows = rows;
        this.batch = schema.createRowBatch();
    }

    @Override
    public void close() throws IOException {
        this.rows.close();
    }

    private void advance() {
        if (!this.advanced) {
            try {
                this.rows.nextBatch(this.batch);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem reading ORC file " + this.fileLocation, e);
            }
            this.advanced = true;
        }
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.batch.size > 0;
    }

    @Override
    public VectorizedRowBatch next() {
        this.advance();
        this.advanced = false;
        return this.batch;
    }
}

