/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.shaded.com.google.common.base.Joiner;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.org.apache.parquet.Preconditions;
import org.apache.iceberg.shaded.org.apache.parquet.schema.DecimalMetadata;
import org.apache.iceberg.shaded.org.apache.parquet.schema.GroupType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.OriginalType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Type;
import org.apache.iceberg.types.Types;

class MessageTypeToType
extends ParquetTypeVisitor<org.apache.iceberg.types.Type> {
    private static final Joiner DOT = Joiner.on(".");
    private final Map<String, Integer> aliasToId = Maps.newHashMap();
    private final GroupType root;
    private int nextId = 1;

    public MessageTypeToType(GroupType root) {
        this.root = root;
        this.nextId = 1000;
    }

    public Map<String, Integer> getAliases() {
        return this.aliasToId;
    }

    @Override
    public org.apache.iceberg.types.Type message(MessageType message, List<org.apache.iceberg.types.Type> fields) {
        return this.struct((GroupType)message, (List)fields);
    }

    @Override
    public org.apache.iceberg.types.Type struct(GroupType struct, List<org.apache.iceberg.types.Type> fieldTypes) {
        if (struct == this.root) {
            this.nextId = 1;
        }
        List<Type> parquetFields = struct.getFields();
        ArrayList<Types.NestedField> fields = Lists.newArrayListWithExpectedSize(fieldTypes.size());
        for (int i = 0; i < parquetFields.size(); ++i) {
            Type field = parquetFields.get(i);
            Preconditions.checkArgument(!field.isRepetition(Type.Repetition.REPEATED), "Fields cannot have repetition REPEATED: {}", field);
            int fieldId = this.getId(field);
            this.addAlias(field.getName(), fieldId);
            if (parquetFields.get(i).isRepetition(Type.Repetition.OPTIONAL)) {
                fields.add(Types.NestedField.optional(fieldId, field.getName(), fieldTypes.get(i)));
                continue;
            }
            fields.add(Types.NestedField.required(fieldId, field.getName(), fieldTypes.get(i)));
        }
        return Types.StructType.of(fields);
    }

    @Override
    public org.apache.iceberg.types.Type list(GroupType array, org.apache.iceberg.types.Type elementType) {
        GroupType repeated = array.getType(0).asGroupType();
        Type element = repeated.getType(0);
        Preconditions.checkArgument(!element.isRepetition(Type.Repetition.REPEATED), "Elements cannot have repetition REPEATED: {}", element);
        int elementFieldId = this.getId(element);
        this.addAlias(element.getName(), elementFieldId);
        if (element.isRepetition(Type.Repetition.OPTIONAL)) {
            return Types.ListType.ofOptional(elementFieldId, elementType);
        }
        return Types.ListType.ofRequired(elementFieldId, elementType);
    }

    @Override
    public org.apache.iceberg.types.Type map(GroupType map, org.apache.iceberg.types.Type keyType, org.apache.iceberg.types.Type valueType) {
        GroupType keyValue = map.getType(0).asGroupType();
        Type key = keyValue.getType(0);
        Type value = keyValue.getType(1);
        Preconditions.checkArgument(!value.isRepetition(Type.Repetition.REPEATED), "Values cannot have repetition REPEATED: {}", value);
        int keyFieldId = this.getId(key);
        int valueFieldId = this.getId(value);
        this.addAlias(key.getName(), keyFieldId);
        this.addAlias(value.getName(), valueFieldId);
        if (value.isRepetition(Type.Repetition.OPTIONAL)) {
            return Types.MapType.ofOptional(keyFieldId, valueFieldId, keyType, valueType);
        }
        return Types.MapType.ofRequired(keyFieldId, valueFieldId, keyType, valueType);
    }

    @Override
    public org.apache.iceberg.types.Type primitive(PrimitiveType primitive) {
        OriginalType annotation = primitive.getOriginalType();
        if (annotation != null) {
            switch (annotation) {
                case INT_8: 
                case UINT_8: 
                case INT_16: 
                case UINT_16: 
                case INT_32: {
                    return Types.IntegerType.get();
                }
                case INT_64: {
                    return Types.LongType.get();
                }
                case DATE: {
                    return Types.DateType.get();
                }
                case TIME_MILLIS: 
                case TIME_MICROS: {
                    return Types.TimeType.get();
                }
                case TIMESTAMP_MILLIS: 
                case TIMESTAMP_MICROS: {
                    return Types.TimestampType.withZone();
                }
                case JSON: 
                case BSON: 
                case ENUM: 
                case UTF8: {
                    return Types.StringType.get();
                }
                case DECIMAL: {
                    DecimalMetadata decimal = primitive.getDecimalMetadata();
                    return Types.DecimalType.of(decimal.getPrecision(), decimal.getScale());
                }
            }
            throw new UnsupportedOperationException("Unsupported logical type: " + (Object)((Object)annotation));
        }
        switch (primitive.getPrimitiveTypeName()) {
            case BOOLEAN: {
                return Types.BooleanType.get();
            }
            case INT32: {
                return Types.IntegerType.get();
            }
            case INT64: {
                return Types.LongType.get();
            }
            case FLOAT: {
                return Types.FloatType.get();
            }
            case DOUBLE: {
                return Types.DoubleType.get();
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return Types.FixedType.ofLength(primitive.getTypeLength());
            }
            case BINARY: {
                return Types.BinaryType.get();
            }
        }
        throw new UnsupportedOperationException("Cannot convert unknown primitive type: " + primitive);
    }

    private void addAlias(int fieldId) {
        if (!this.fieldNames.isEmpty()) {
            String fullName = DOT.join(this.fieldNames.descendingIterator());
            this.aliasToId.put(fullName, fieldId);
        }
    }

    private void addAlias(String name, int fieldId) {
        String fullName = name;
        if (!this.fieldNames.isEmpty()) {
            fullName = DOT.join(DOT.join(this.fieldNames.descendingIterator()), name, new Object[0]);
        }
        this.aliasToId.put(fullName, fieldId);
    }

    protected int nextId() {
        int current = this.nextId++;
        return current;
    }

    private int getId(Type type) {
        Type.ID id = type.getId();
        if (id != null) {
            return id.intValue();
        }
        return this.nextId();
    }
}

