/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.parquet.ParquetConversions;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.org.apache.avro.shaded.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.iceberg.shaded.org.apache.parquet.column.Dictionary;
import org.apache.iceberg.shaded.org.apache.parquet.column.Encoding;
import org.apache.iceberg.shaded.org.apache.parquet.column.EncodingStats;
import org.apache.iceberg.shaded.org.apache.parquet.column.page.DictionaryPage;
import org.apache.iceberg.shaded.org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.types.Types;

public class ParquetDictionaryRowGroupFilter {
    private final Schema schema;
    private final Types.StructType struct;
    private final Expression expr;
    private transient ThreadLocal<EvalVisitor> visitors = null;
    private static final boolean ROWS_MIGHT_MATCH = true;
    private static final boolean ROWS_CANNOT_MATCH = false;

    private EvalVisitor visitor() {
        if (this.visitors == null) {
            this.visitors = ThreadLocal.withInitial(() -> new EvalVisitor());
        }
        return this.visitors.get();
    }

    public ParquetDictionaryRowGroupFilter(Schema schema, Expression unbound) {
        this(schema, unbound, true);
    }

    public ParquetDictionaryRowGroupFilter(Schema schema, Expression unbound, boolean caseSensitive) {
        this.schema = schema;
        this.struct = schema.asStruct();
        this.expr = Binder.bind(this.struct, Expressions.rewriteNot(unbound), caseSensitive);
    }

    public boolean shouldRead(MessageType fileSchema, BlockMetaData rowGroup, DictionaryPageReadStore dictionaries) {
        return this.visitor().eval(fileSchema, rowGroup, dictionaries);
    }

    private static boolean mayContainNull(ColumnChunkMetaData meta) {
        return meta.getStatistics() == null || meta.getStatistics().getNumNulls() != 0L;
    }

    private static boolean hasNonDictionaryPages(ColumnChunkMetaData meta) {
        EncodingStats stats = meta.getEncodingStats();
        if (stats != null) {
            return stats.hasNonDictionaryEncodedPages();
        }
        HashSet<Encoding> encodings = new HashSet<Encoding>(meta.getEncodings());
        if (encodings.remove((Object)Encoding.PLAIN_DICTIONARY)) {
            encodings.remove((Object)Encoding.RLE);
            encodings.remove((Object)Encoding.BIT_PACKED);
            return !encodings.isEmpty();
        }
        return true;
    }

    private class EvalVisitor
    extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
        private DictionaryPageReadStore dictionaries = null;
        private Map<Integer, Set<?>> dictCache = null;
        private Map<Integer, Boolean> isFallback = null;
        private Map<Integer, Boolean> mayContainNulls = null;
        private Map<Integer, ColumnDescriptor> cols = null;
        private Map<Integer, Function<Object, Object>> conversions = null;

        private EvalVisitor() {
        }

        private boolean eval(MessageType fileSchema, BlockMetaData rowGroup, DictionaryPageReadStore dictionaries) {
            int id;
            PrimitiveType colType;
            this.dictionaries = dictionaries;
            this.dictCache = Maps.newHashMap();
            this.isFallback = Maps.newHashMap();
            this.mayContainNulls = Maps.newHashMap();
            this.cols = Maps.newHashMap();
            this.conversions = Maps.newHashMap();
            for (ColumnDescriptor desc : fileSchema.getColumns()) {
                colType = fileSchema.getType(desc.getPath()).asPrimitiveType();
                if (colType.getId() == null) continue;
                id = colType.getId().intValue();
                this.cols.put(id, desc);
                this.conversions.put(id, ParquetConversions.converterFromParquet(colType));
            }
            for (ColumnChunkMetaData meta : rowGroup.getColumns()) {
                colType = fileSchema.getType(meta.getPath().toArray()).asPrimitiveType();
                if (colType.getId() == null) continue;
                id = colType.getId().intValue();
                this.isFallback.put(id, ParquetDictionaryRowGroupFilter.hasNonDictionaryPages(meta));
                this.mayContainNulls.put(id, ParquetDictionaryRowGroupFilter.mayContainNull(meta));
            }
            return ExpressionVisitors.visitEvaluator(ParquetDictionaryRowGroupFilter.this.expr, this);
        }

        @Override
        public Boolean alwaysTrue() {
            return true;
        }

        @Override
        public Boolean alwaysFalse() {
            return false;
        }

        @Override
        public Boolean not(Boolean result) {
            return result == false;
        }

        @Override
        public Boolean and(Boolean leftResult, Boolean rightResult) {
            return leftResult != false && rightResult != false;
        }

        @Override
        public Boolean or(Boolean leftResult, Boolean rightResult) {
            return leftResult != false || rightResult != false;
        }

        @Override
        public <T> Boolean isNull(BoundReference<T> ref) {
            return true;
        }

        @Override
        public <T> Boolean notNull(BoundReference<T> ref) {
            return true;
        }

        @Override
        public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            for (T item : dictionary) {
                int cmp = lit.comparator().compare(item, lit.value());
                if (cmp >= 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            for (T item : dictionary) {
                int cmp = lit.comparator().compare(item, lit.value());
                if (cmp > 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            for (T item : dictionary) {
                int cmp = lit.comparator().compare(item, lit.value());
                if (cmp <= 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            for (T item : dictionary) {
                int cmp = lit.comparator().compare(item, lit.value());
                if (cmp < 0) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            return dictionary.contains(lit.value());
        }

        @Override
        public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            if (dictionary.size() > 1 || this.mayContainNulls.get(id).booleanValue()) {
                return true;
            }
            return !dictionary.contains(lit.value());
        }

        @Override
        public <T> Boolean in(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        @Override
        public <T> Boolean notIn(BoundReference<T> ref, Literal<T> lit) {
            return true;
        }

        @Override
        public <T> Boolean startsWith(BoundReference<T> ref, Literal<T> lit) {
            Integer id = ref.fieldId();
            Boolean hasNonDictPage = this.isFallback.get(id);
            if (hasNonDictPage == null || hasNonDictPage.booleanValue()) {
                return true;
            }
            Set<T> dictionary = this.dict(id, lit.comparator());
            for (T item : dictionary) {
                if (!item.toString().startsWith(lit.value().toString())) continue;
                return true;
            }
            return false;
        }

        private <T> Set<T> dict(int id, Comparator<T> comparator) {
            Dictionary dict;
            Preconditions.checkNotNull(this.dictionaries, "Dictionary is required");
            Set<?> cached = this.dictCache.get(id);
            if (cached != null) {
                return cached;
            }
            ColumnDescriptor col = this.cols.get(id);
            DictionaryPage page = this.dictionaries.readDictionaryPage(col);
            if (page == null) {
                throw new IllegalStateException("Failed to read required dictionary page for id: " + id);
            }
            Function<Object, Object> conversion = this.conversions.get(id);
            try {
                dict = page.getEncoding().initDictionary(col, page);
            }
            catch (IOException e) {
                throw new RuntimeIOException("Failed to create reader for dictionary page", new Object[0]);
            }
            TreeSet<T> dictSet = Sets.newTreeSet(comparator);
            block9: for (int i = 0; i <= dict.getMaxId(); ++i) {
                switch (col.getPrimitiveType().getPrimitiveTypeName()) {
                    case BINARY: {
                        dictSet.add(conversion.apply(dict.decodeToBinary(i)));
                        continue block9;
                    }
                    case INT32: {
                        dictSet.add(conversion.apply(dict.decodeToInt(i)));
                        continue block9;
                    }
                    case INT64: {
                        dictSet.add(conversion.apply(dict.decodeToLong(i)));
                        continue block9;
                    }
                    case FLOAT: {
                        dictSet.add(conversion.apply(Float.valueOf(dict.decodeToFloat(i))));
                        continue block9;
                    }
                    case DOUBLE: {
                        dictSet.add(conversion.apply(dict.decodeToDouble(i)));
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot decode dictionary of type: " + (Object)((Object)col.getPrimitiveType().getPrimitiveTypeName()));
                    }
                }
            }
            this.dictCache.put(id, dictSet);
            return dictSet;
        }
    }
}

