/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.nio.ByteBuffer;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.predicate.Operators;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.Binary;

class ParquetFilters {
    ParquetFilters() {
    }

    static FilterCompat.Filter convert(Schema schema, Expression expr, boolean caseSensitive) {
        FilterPredicate pred = ExpressionVisitors.visit(expr, new ConvertFilterToParquet(schema, caseSensitive));
        if (pred != null && pred != AlwaysTrue.INSTANCE) {
            return FilterCompat.get(pred);
        }
        return FilterCompat.NOOP;
    }

    private static <C extends Comparable<C>, COL extends Operators.Column<C>> FilterPredicate pred(Expression.Operation op, COL col, C value) {
        switch (op) {
            case IS_NULL: {
                return FilterApi.eq(col, null);
            }
            case NOT_NULL: {
                return FilterApi.notEq(col, null);
            }
            case EQ: {
                return FilterApi.eq(col, value);
            }
            case NOT_EQ: {
                return FilterApi.notEq(col, value);
            }
            case GT: {
                return FilterApi.gt(col, value);
            }
            case GT_EQ: {
                return FilterApi.gtEq(col, value);
            }
            case LT: {
                return FilterApi.lt(col, value);
            }
            case LT_EQ: {
                return FilterApi.ltEq(col, value);
            }
        }
        throw new UnsupportedOperationException("Unsupported predicate operation: " + (Object)((Object)op));
    }

    private static <C extends Comparable<C>> C getParquetPrimitive(Literal<?> lit) {
        if (lit == null) {
            return null;
        }
        Object value = lit.value();
        if (value instanceof Number) {
            return (C)((Comparable)lit.value());
        }
        if (value instanceof CharSequence) {
            return (C)Binary.fromString(value.toString());
        }
        if (value instanceof ByteBuffer) {
            return (C)Binary.fromReusedByteBuffer((ByteBuffer)value);
        }
        throw new UnsupportedOperationException("Type not supported yet: " + value.getClass().getName());
    }

    private static class AlwaysFalse
    implements FilterPredicate {
        static final AlwaysFalse INSTANCE = new AlwaysFalse();

        private AlwaysFalse() {
        }

        @Override
        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            throw new UnsupportedOperationException("AlwaysTrue is a placeholder only");
        }
    }

    private static class AlwaysTrue
    implements FilterPredicate {
        static final AlwaysTrue INSTANCE = new AlwaysTrue();

        private AlwaysTrue() {
        }

        @Override
        public <R> R accept(FilterPredicate.Visitor<R> visitor) {
            throw new UnsupportedOperationException("AlwaysTrue is a placeholder only");
        }
    }

    private static class ConvertFilterToParquet
    extends ExpressionVisitors.ExpressionVisitor<FilterPredicate> {
        private final Schema schema;
        private final boolean caseSensitive;

        private ConvertFilterToParquet(Schema schema, boolean caseSensitive) {
            this.schema = schema;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public FilterPredicate alwaysTrue() {
            return AlwaysTrue.INSTANCE;
        }

        @Override
        public FilterPredicate alwaysFalse() {
            return AlwaysFalse.INSTANCE;
        }

        @Override
        public FilterPredicate not(FilterPredicate child) {
            if (child == AlwaysTrue.INSTANCE) {
                return AlwaysFalse.INSTANCE;
            }
            if (child == AlwaysFalse.INSTANCE) {
                return AlwaysTrue.INSTANCE;
            }
            return FilterApi.not(child);
        }

        @Override
        public FilterPredicate and(FilterPredicate left, FilterPredicate right) {
            if (left == AlwaysFalse.INSTANCE || right == AlwaysFalse.INSTANCE) {
                return AlwaysFalse.INSTANCE;
            }
            if (left == AlwaysTrue.INSTANCE) {
                return right;
            }
            if (right == AlwaysTrue.INSTANCE) {
                return left;
            }
            return FilterApi.and(left, right);
        }

        @Override
        public FilterPredicate or(FilterPredicate left, FilterPredicate right) {
            if (left == AlwaysTrue.INSTANCE || right == AlwaysTrue.INSTANCE) {
                return AlwaysTrue.INSTANCE;
            }
            if (left == AlwaysFalse.INSTANCE) {
                return right;
            }
            if (right == AlwaysFalse.INSTANCE) {
                return left;
            }
            return FilterApi.or(left, right);
        }

        @Override
        public <T> FilterPredicate predicate(BoundPredicate<T> pred) {
            Expression.Operation op = pred.op();
            BoundReference ref = (BoundReference)pred.ref();
            Literal lit = pred.literal();
            String path = this.schema.idToAlias(ref.fieldId());
            switch (ref.type().typeId()) {
                case BOOLEAN: {
                    Operators.BooleanColumn col = FilterApi.booleanColumn(this.schema.idToAlias(ref.fieldId()));
                    switch (op) {
                        case EQ: {
                            return FilterApi.eq(col, ParquetFilters.getParquetPrimitive(lit));
                        }
                        case NOT_EQ: {
                            return FilterApi.eq(col, ParquetFilters.getParquetPrimitive(lit));
                        }
                    }
                }
                case INTEGER: {
                    return ParquetFilters.pred(op, FilterApi.intColumn(path), ParquetFilters.getParquetPrimitive(lit));
                }
                case LONG: {
                    return ParquetFilters.pred(op, FilterApi.longColumn(path), ParquetFilters.getParquetPrimitive(lit));
                }
                case FLOAT: {
                    return ParquetFilters.pred(op, FilterApi.floatColumn(path), ParquetFilters.getParquetPrimitive(lit));
                }
                case DOUBLE: {
                    return ParquetFilters.pred(op, FilterApi.doubleColumn(path), ParquetFilters.getParquetPrimitive(lit));
                }
                case DATE: {
                    return ParquetFilters.pred(op, FilterApi.intColumn(path), ParquetFilters.getParquetPrimitive(lit));
                }
                case TIME: {
                    return ParquetFilters.pred(op, FilterApi.longColumn(path), ParquetFilters.getParquetPrimitive(lit));
                }
                case TIMESTAMP: {
                    return ParquetFilters.pred(op, FilterApi.longColumn(path), ParquetFilters.getParquetPrimitive(lit));
                }
                case STRING: {
                    return ParquetFilters.pred(op, FilterApi.binaryColumn(path), ParquetFilters.getParquetPrimitive(lit));
                }
                case UUID: {
                    return ParquetFilters.pred(op, FilterApi.binaryColumn(path), ParquetFilters.getParquetPrimitive(lit));
                }
                case FIXED: {
                    return ParquetFilters.pred(op, FilterApi.binaryColumn(path), ParquetFilters.getParquetPrimitive(lit));
                }
                case BINARY: {
                    return ParquetFilters.pred(op, FilterApi.binaryColumn(path), ParquetFilters.getParquetPrimitive(lit));
                }
                case DECIMAL: {
                    return ParquetFilters.pred(op, FilterApi.binaryColumn(path), ParquetFilters.getParquetPrimitive(lit));
                }
            }
            throw new UnsupportedOperationException("Cannot convert to Parquet filter: " + pred);
        }

        protected Expression bind(UnboundPredicate<?> pred) {
            return pred.bind(this.schema.asStruct(), this.caseSensitive);
        }

        @Override
        public <T> FilterPredicate predicate(UnboundPredicate<T> pred) {
            Expression bound = this.bind(pred);
            if (bound instanceof BoundPredicate) {
                return this.predicate((BoundPredicate)bound);
            }
            if (bound == Expressions.alwaysTrue()) {
                return AlwaysTrue.INSTANCE;
            }
            if (bound == Expressions.alwaysFalse()) {
                return AlwaysFalse.INSTANCE;
            }
            throw new UnsupportedOperationException("Cannot convert to Parquet filter: " + pred);
        }
    }
}

