/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.parquet.ParquetAvro;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.shaded.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.shaded.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.org.apache.parquet.avro.AvroReadSupport;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.api.InitContext;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.RecordMaterializer;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;

class ParquetReadSupport<T>
extends ReadSupport<T> {
    private final Schema expectedSchema;
    private final ReadSupport<T> wrapped;
    private final boolean callInit;

    ParquetReadSupport(Schema expectedSchema, ReadSupport<T> readSupport, boolean callInit) {
        this.expectedSchema = expectedSchema;
        this.wrapped = readSupport;
        this.callInit = callInit;
    }

    @Override
    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        MessageType projection = ParquetSchemaUtil.hasIds(fileSchema) ? ParquetSchemaUtil.pruneColumns(fileSchema, this.expectedSchema) : ParquetSchemaUtil.pruneColumnsFallback(fileSchema, this.expectedSchema);
        configuration.set("parquet.strict.typing", "false");
        configuration.set("parquet.avro.add-list-element-records", "false");
        configuration.set("parquet.avro.write-old-list-structure", "false");
        AvroReadSupport.setRequestedProjection(configuration, AvroSchemaUtil.convert(this.expectedSchema, projection.getName()));
        org.apache.iceberg.shaded.org.apache.avro.Schema avroReadSchema = AvroSchemaUtil.buildAvroProjection(AvroSchemaUtil.convert(ParquetSchemaUtil.convert(projection), projection.getName()), this.expectedSchema, ImmutableMap.of());
        AvroReadSupport.setAvroReadSchema(configuration, ParquetAvro.parquetAvroSchema(avroReadSchema));
        ReadSupport.ReadContext context = null;
        if (this.callInit) {
            try {
                context = this.wrapped.init(configuration, keyValueMetaData, projection);
            }
            catch (UnsupportedOperationException e) {
                context = this.wrapped.init(new InitContext(configuration, this.makeMultimap(keyValueMetaData), projection));
            }
        }
        return new ReadSupport.ReadContext(projection, context != null ? context.getReadSupportMetadata() : ImmutableMap.of());
    }

    @Override
    public RecordMaterializer<T> prepareForRead(Configuration configuration, Map<String, String> fileMetadata, MessageType fileMessageType, ReadSupport.ReadContext readContext) {
        MessageType readSchema = ParquetSchemaUtil.convert(this.expectedSchema, fileMessageType.getName());
        return this.wrapped.prepareForRead(configuration, fileMetadata, readSchema, readContext);
    }

    private Map<String, Set<String>> makeMultimap(Map<String, String> map) {
        ImmutableMap.Builder<String, HashSet<String>> builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.put(entry.getKey(), Sets.newHashSet(entry.getValue()));
        }
        return builder.build();
    }
}

