/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.HashSet;
import java.util.Set;
import org.apache.iceberg.Schema;
import org.apache.iceberg.parquet.MessageTypeToType;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.parquet.PruneColumns;
import org.apache.iceberg.parquet.TypeToMessageType;
import org.apache.iceberg.shaded.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Type;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Types;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class ParquetSchemaUtil {
    public static MessageType convert(Schema schema, String name) {
        return new TypeToMessageType().convert(schema, name);
    }

    public static Schema convert(MessageType parquetSchema) {
        MessageTypeToType converter = new MessageTypeToType(parquetSchema);
        return new Schema(ParquetTypeVisitor.visit(parquetSchema, converter).asNestedType().fields(), converter.getAliases());
    }

    public static MessageType pruneColumns(MessageType fileSchema, Schema expectedSchema) {
        Set<Integer> selectedIds = TypeUtil.getProjectedIds(expectedSchema);
        return (MessageType)ParquetTypeVisitor.visit(fileSchema, new PruneColumns(selectedIds));
    }

    public static MessageType pruneColumnsFallback(MessageType fileSchema, Schema expectedSchema) {
        HashSet<Integer> selectedIds = Sets.newHashSet();
        for (Types.NestedField field : expectedSchema.columns()) {
            selectedIds.add(field.fieldId());
        }
        Types.MessageTypeBuilder builder = Types.buildMessage();
        int ordinal = 1;
        for (Type type : fileSchema.getFields()) {
            if (selectedIds.contains(ordinal)) {
                builder.addField(type.withId(ordinal));
            }
            ++ordinal;
        }
        return builder.named(fileSchema.getName());
    }

    public static boolean hasIds(MessageType fileSchema) {
        try {
            ParquetTypeVisitor.visit(fileSchema, new MessageTypeToType(fileSchema){

                @Override
                protected int nextId() {
                    throw new IllegalStateException("Needed to assign ID");
                }
            });
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public static MessageType addFallbackIds(MessageType fileSchema) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        int ordinal = 1;
        for (Type type : fileSchema.getFields()) {
            builder.addField(type.withId(ordinal));
            ++ordinal;
        }
        return builder.named(fileSchema.getName());
    }
}

