/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.parquet.schema.GroupType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.OriginalType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Type;

public class ParquetTypeVisitor<T> {
    protected LinkedList<String> fieldNames = Lists.newLinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T visit(Type type, ParquetTypeVisitor<T> visitor) {
        if (type instanceof MessageType) {
            return visitor.message((MessageType)type, ParquetTypeVisitor.visitFields(type.asGroupType(), visitor));
        }
        if (type.isPrimitive()) {
            return visitor.primitive(type.asPrimitiveType());
        }
        GroupType group = type.asGroupType();
        OriginalType annotation = group.getOriginalType();
        if (annotation != null) {
            switch (annotation) {
                case LIST: {
                    Preconditions.checkArgument(!group.isRepetition(Type.Repetition.REPEATED), "Invalid list: top-level group is repeated: " + group);
                    Preconditions.checkArgument(group.getFieldCount() == 1, "Invalid list: does not contain single repeated field: " + group);
                    GroupType repeatedElement = group.getFields().get(0).asGroupType();
                    Preconditions.checkArgument(repeatedElement.isRepetition(Type.Repetition.REPEATED), "Invalid list: inner group is not repeated");
                    Preconditions.checkArgument(repeatedElement.getFieldCount() <= 1, "Invalid list: repeated group is not a single field: " + group);
                    visitor.fieldNames.push(repeatedElement.getName());
                    try {
                        T elementResult = null;
                        if (repeatedElement.getFieldCount() > 0) {
                            elementResult = ParquetTypeVisitor.visitField(repeatedElement.getType(0), visitor);
                        }
                        T t = visitor.list(group, elementResult);
                        return t;
                    }
                    finally {
                        visitor.fieldNames.pop();
                    }
                }
                case MAP: {
                    Preconditions.checkArgument(!group.isRepetition(Type.Repetition.REPEATED), "Invalid map: top-level group is repeated: " + group);
                    Preconditions.checkArgument(group.getFieldCount() == 1, "Invalid map: does not contain single repeated field: " + group);
                    GroupType repeatedKeyValue = group.getType(0).asGroupType();
                    Preconditions.checkArgument(repeatedKeyValue.isRepetition(Type.Repetition.REPEATED), "Invalid map: inner group is not repeated");
                    Preconditions.checkArgument(repeatedKeyValue.getFieldCount() <= 2, "Invalid map: repeated group does not have 2 fields");
                    visitor.fieldNames.push(repeatedKeyValue.getName());
                    try {
                        T keyResult = null;
                        T valueResult = null;
                        switch (repeatedKeyValue.getFieldCount()) {
                            case 2: {
                                keyResult = ParquetTypeVisitor.visitField(repeatedKeyValue.getType(0), visitor);
                                valueResult = ParquetTypeVisitor.visitField(repeatedKeyValue.getType(1), visitor);
                            }
                            case 1: {
                                Type keyOrValue = repeatedKeyValue.getType(0);
                                if (keyOrValue.getName().equalsIgnoreCase("key")) {
                                    keyResult = ParquetTypeVisitor.visitField(keyOrValue, visitor);
                                    break;
                                }
                                valueResult = ParquetTypeVisitor.visitField(keyOrValue, visitor);
                            }
                        }
                        T t = visitor.map(group, keyResult, valueResult);
                        return t;
                    }
                    finally {
                        visitor.fieldNames.pop();
                    }
                }
            }
        }
        return visitor.struct(group, ParquetTypeVisitor.visitFields(group, visitor));
    }

    private static <T> T visitField(Type field, ParquetTypeVisitor<T> visitor) {
        visitor.fieldNames.push(field.getName());
        try {
            T t = ParquetTypeVisitor.visit(field, visitor);
            return t;
        }
        finally {
            visitor.fieldNames.pop();
        }
    }

    private static <T> List<T> visitFields(GroupType group, ParquetTypeVisitor<T> visitor) {
        ArrayList<T> results = Lists.newArrayListWithExpectedSize(group.getFieldCount());
        for (Type field : group.getFields()) {
            results.add(ParquetTypeVisitor.visitField(field, visitor));
        }
        return results;
    }

    public T message(MessageType message, List<T> fields) {
        return null;
    }

    public T struct(GroupType struct, List<T> fields) {
        return null;
    }

    public T list(GroupType array, T element) {
        return null;
    }

    public T map(GroupType map, T key, T value) {
        return null;
    }

    public T primitive(PrimitiveType primitive) {
        return null;
    }
}

