/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.parquet.ParquetConversions;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.shaded.com.google.common.collect.Maps;
import org.apache.iceberg.shaded.com.google.common.collect.Sets;
import org.apache.iceberg.shaded.org.apache.parquet.column.statistics.Statistics;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BinaryUtil;
import org.apache.iceberg.util.UnicodeUtil;

public class ParquetUtil {
    private ParquetUtil() {
    }

    static Metrics fileMetrics(InputFile file) {
        return ParquetUtil.fileMetrics(file, MetricsConfig.getDefault());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Metrics fileMetrics(InputFile file, MetricsConfig metricsConfig) {
        try (ParquetFileReader reader = ParquetFileReader.open(ParquetIO.file(file));){
            Metrics metrics = ParquetUtil.footerMetrics(reader.getFooter(), metricsConfig);
            return metrics;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to read footer of file: %s", file);
        }
    }

    public static Metrics footerMetrics(ParquetMetadata metadata, MetricsConfig metricsConfig) {
        long rowCount = 0L;
        HashMap<Integer, Long> columnSizes = Maps.newHashMap();
        HashMap<Integer, Long> valueCounts = Maps.newHashMap();
        HashMap<Integer, Long> nullValueCounts = Maps.newHashMap();
        HashMap<Integer, Literal<?>> lowerBounds = Maps.newHashMap();
        HashMap<Integer, Literal<?>> upperBounds = Maps.newHashMap();
        HashSet<Integer> missingStats = Sets.newHashSet();
        MessageType parquetType = metadata.getFileMetaData().getSchema();
        Schema fileSchema = ParquetSchemaUtil.convert(parquetType);
        List<BlockMetaData> blocks = metadata.getBlocks();
        for (BlockMetaData block : blocks) {
            rowCount += block.getRowCount();
            for (ColumnChunkMetaData column : block.getColumns()) {
                Types.NestedField field;
                ColumnPath path = column.getPath();
                int fieldId = fileSchema.aliasToId(path.toDotString());
                ParquetUtil.increment(columnSizes, fieldId, column.getTotalSize());
                String columnName = fileSchema.findColumnName(fieldId);
                MetricsModes.MetricsMode metricsMode = metricsConfig.columnMode(columnName);
                if (metricsMode == MetricsModes.None.get()) continue;
                ParquetUtil.increment(valueCounts, fieldId, column.getValueCount());
                Statistics stats = column.getStatistics();
                if (stats == null) {
                    missingStats.add(fieldId);
                    continue;
                }
                if (stats.isEmpty()) continue;
                ParquetUtil.increment(nullValueCounts, fieldId, stats.getNumNulls());
                if (metricsMode == MetricsModes.Counts.get() || (field = fileSchema.findField(fieldId)) == null || !stats.hasNonNullValue() || !ParquetUtil.shouldStoreBounds(path, fileSchema)) continue;
                Literal min2 = ParquetConversions.fromParquetPrimitive(field.type(), column.getPrimitiveType(), stats.genericGetMin());
                ParquetUtil.updateMin(lowerBounds, fieldId, field.type(), min2, metricsMode);
                Literal max = ParquetConversions.fromParquetPrimitive(field.type(), column.getPrimitiveType(), stats.genericGetMax());
                ParquetUtil.updateMax(upperBounds, fieldId, field.type(), max, metricsMode);
            }
        }
        for (Integer fieldId : missingStats) {
            nullValueCounts.remove(fieldId);
            lowerBounds.remove(fieldId);
            upperBounds.remove(fieldId);
        }
        return new Metrics(rowCount, columnSizes, valueCounts, nullValueCounts, ParquetUtil.toBufferMap(fileSchema, lowerBounds), ParquetUtil.toBufferMap(fileSchema, upperBounds));
    }

    public static List<Long> getSplitOffsets(ParquetMetadata md) {
        ArrayList<Long> splitOffsets = new ArrayList<Long>(md.getBlocks().size());
        for (BlockMetaData blockMetaData : md.getBlocks()) {
            splitOffsets.add(blockMetaData.getStartingPos());
        }
        Collections.sort(splitOffsets);
        return splitOffsets;
    }

    private static boolean shouldStoreBounds(ColumnPath columnPath, Schema schema) {
        Iterator<String> pathIterator = columnPath.iterator();
        Type currentType = schema.asStruct();
        while (pathIterator.hasNext()) {
            if (currentType == null || !currentType.isStructType()) {
                return false;
            }
            String fieldName = pathIterator.next();
            currentType = currentType.asStructType().fieldType(fieldName);
        }
        return currentType != null && currentType.isPrimitiveType();
    }

    private static void increment(Map<Integer, Long> columns, int fieldId, long amount) {
        if (columns != null) {
            if (columns.containsKey(fieldId)) {
                columns.put(fieldId, columns.get(fieldId) + amount);
            } else {
                columns.put(fieldId, amount);
            }
        }
    }

    private static <T> void updateMin(Map<Integer, Literal<?>> lowerBounds, int id, Type type, Literal<T> min2, MetricsModes.MetricsMode metricsMode) {
        Literal<?> currentMin = lowerBounds.get(id);
        if (currentMin == null || min2.comparator().compare(min2.value(), currentMin.value()) < 0) {
            if (metricsMode == MetricsModes.Full.get()) {
                lowerBounds.put(id, min2);
            } else {
                MetricsModes.Truncate truncateMode = (MetricsModes.Truncate)metricsMode;
                int truncateLength = truncateMode.length();
                switch (type.typeId()) {
                    case STRING: {
                        lowerBounds.put(id, UnicodeUtil.truncateStringMin(min2, truncateLength));
                        break;
                    }
                    case FIXED: 
                    case BINARY: {
                        lowerBounds.put(id, BinaryUtil.truncateBinaryMin(min2, truncateLength));
                        break;
                    }
                    default: {
                        lowerBounds.put(id, min2);
                    }
                }
            }
        }
    }

    private static <T> void updateMax(Map<Integer, Literal<?>> upperBounds, int id, Type type, Literal<T> max, MetricsModes.MetricsMode metricsMode) {
        Literal<?> currentMax = upperBounds.get(id);
        if (currentMax == null || max.comparator().compare(max.value(), currentMax.value()) > 0) {
            if (metricsMode == MetricsModes.Full.get()) {
                upperBounds.put(id, max);
            } else {
                MetricsModes.Truncate truncateMode = (MetricsModes.Truncate)metricsMode;
                int truncateLength = truncateMode.length();
                switch (type.typeId()) {
                    case STRING: {
                        upperBounds.put(id, UnicodeUtil.truncateStringMax(max, truncateLength));
                        break;
                    }
                    case FIXED: 
                    case BINARY: {
                        upperBounds.put(id, BinaryUtil.truncateBinaryMax(max, truncateLength));
                        break;
                    }
                    default: {
                        upperBounds.put(id, max);
                    }
                }
            }
        }
    }

    private static Map<Integer, ByteBuffer> toBufferMap(Schema schema, Map<Integer, Literal<?>> map) {
        HashMap<Integer, ByteBuffer> bufferMap = Maps.newHashMap();
        for (Map.Entry<Integer, Literal<?>> entry : map.entrySet()) {
            bufferMap.put(entry.getKey(), Conversions.toByteBuffer(schema.findType(entry.getKey()), entry.getValue().value()));
        }
        return bufferMap;
    }
}

