/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.IOException;
import java.util.List;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.ParquetWriter;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ParquetMetadata;

public class ParquetWriteAdapter<D>
implements FileAppender<D> {
    private ParquetWriter<D> writer;
    private MetricsConfig metricsConfig;
    private ParquetMetadata footer;

    public ParquetWriteAdapter(ParquetWriter<D> writer, MetricsConfig metricsConfig) {
        this.writer = writer;
        this.metricsConfig = metricsConfig;
    }

    @Override
    public void add(D datum) {
        try {
            this.writer.write(datum);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to write record %s", datum);
        }
    }

    @Override
    public Metrics metrics() {
        Preconditions.checkState(this.footer != null, "Cannot produce metrics until closed");
        return ParquetUtil.footerMetrics(this.footer, this.metricsConfig);
    }

    @Override
    public long length() {
        return this.writer.getDataSize();
    }

    @Override
    public List<Long> splitOffsets() {
        return ParquetUtil.getSplitOffsets(this.writer.getFooter());
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.footer = this.writer.getFooter();
            this.writer = null;
        }
    }
}

