/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.parquet.schema.GroupType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Type;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Types;

class PruneColumns
extends ParquetTypeVisitor<Type> {
    private final Set<Integer> selectedIds;

    PruneColumns(Set<Integer> selectedIds) {
        this.selectedIds = selectedIds;
    }

    @Override
    public Type message(MessageType message, List<Type> fields) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        boolean hasChange = false;
        int fieldCount = 0;
        for (int i = 0; i < fields.size(); ++i) {
            Type originalField = message.getType(i);
            Type field = fields.get(i);
            if (this.selectedIds.contains(this.getId(originalField))) {
                builder.addField(originalField);
                ++fieldCount;
                continue;
            }
            if (field == null) continue;
            builder.addField(field);
            ++fieldCount;
            hasChange = true;
        }
        if (hasChange) {
            return builder.named(message.getName());
        }
        if (message.getFieldCount() == fieldCount) {
            return message;
        }
        return builder.named(message.getName());
    }

    @Override
    public Type struct(GroupType struct, List<Type> fields) {
        boolean hasChange = false;
        ArrayList<Type> filteredFields = Lists.newArrayListWithExpectedSize(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            Type originalField = struct.getType(i);
            Type field = fields.get(i);
            if (this.selectedIds.contains(this.getId(originalField))) {
                filteredFields.add(originalField);
                continue;
            }
            if (field == null) continue;
            filteredFields.add(originalField);
            hasChange = true;
        }
        if (hasChange) {
            return struct.withNewFields(filteredFields);
        }
        if (struct.getFieldCount() == filteredFields.size()) {
            return struct;
        }
        if (!filteredFields.isEmpty()) {
            return struct.withNewFields(filteredFields);
        }
        return null;
    }

    @Override
    public Type list(GroupType list, Type element) {
        GroupType repeated = list.getType(0).asGroupType();
        Type originalElement = repeated.getType(0);
        int elementId = this.getId(originalElement);
        if (this.selectedIds.contains(elementId)) {
            return list;
        }
        if (element != null) {
            if (element != originalElement) {
                return (Type)((Types.ListBuilder)Types.list(list.getRepetition()).element(element).id(this.getId(list))).named(list.getName());
            }
            return list;
        }
        return null;
    }

    @Override
    public Type map(GroupType map, Type key, Type value) {
        GroupType repeated = map.getType(0).asGroupType();
        Type originalKey = repeated.getType(0);
        Type originalValue = repeated.getType(1);
        int keyId = this.getId(originalKey);
        int valueId = this.getId(originalValue);
        if (this.selectedIds.contains(keyId) || this.selectedIds.contains(valueId)) {
            return map;
        }
        if (value != null) {
            if (value != originalValue) {
                return (Type)((Types.MapBuilder)((Types.MapBuilder)((Types.MapBuilder)Types.map(map.getRepetition()).key(originalKey)).value(value)).id(this.getId(map))).named(map.getName());
            }
            return map;
        }
        return null;
    }

    @Override
    public Type primitive(PrimitiveType primitive) {
        return null;
    }

    private int getId(Type type) {
        Preconditions.checkNotNull(type.getId(), "Missing id for type: " + type);
        return type.getId().intValue();
    }
}

