/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.io.airlift.compress.lzo;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.Adler32;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.iceberg.shaded.io.airlift.compress.lzo.LzoDecompressor;
import org.apache.iceberg.shaded.io.airlift.compress.lzo.LzopCodec;

class HadoopLzopInputStream
extends CompressionInputStream {
    private static final int LZO_IMPLEMENTATION_VERSION = 8288;
    private final LzoDecompressor decompressor = new LzoDecompressor();
    private final InputStream in;
    private final byte[] uncompressedChunk;
    private int uncompressedLength;
    private int uncompressedOffset;
    private boolean finished;
    private byte[] compressed = new byte[0];

    public HadoopLzopInputStream(InputStream in, int maxUncompressedLength) throws IOException {
        super(in);
        this.in = in;
        this.uncompressedChunk = new byte[maxUncompressedLength + 8];
        byte[] magic = new byte[LzopCodec.LZOP_MAGIC.length];
        this.readInput(magic, 0, magic.length);
        if (!Arrays.equals(magic, LzopCodec.LZOP_MAGIC)) {
            throw new IOException("Not an LZOP file");
        }
        byte[] header = new byte[25];
        this.readInput(header, 0, header.length);
        ByteArrayInputStream headerStream = new ByteArrayInputStream(header);
        HadoopLzopInputStream.readBigEndianShort(headerStream);
        int lzoVersion = HadoopLzopInputStream.readBigEndianShort(headerStream);
        if (lzoVersion > 8288) {
            throw new IOException(String.format("Unsupported LZO version 0x%08X", lzoVersion));
        }
        int lzopCompatibility = HadoopLzopInputStream.readBigEndianShort(headerStream);
        if (lzopCompatibility > 4112) {
            throw new IOException(String.format("Unsupported LZOP version 0x%08X", lzopCompatibility));
        }
        int variant = headerStream.read();
        if (variant != 1) {
            throw new IOException(String.format("Unsupported LZO variant %s", variant));
        }
        headerStream.read();
        int flags = HadoopLzopInputStream.readBigEndianInt(headerStream);
        if (flags != 0) {
            throw new IOException(String.format("Unsupported LZO flags %s", flags));
        }
        HadoopLzopInputStream.readBigEndianInt(headerStream);
        HadoopLzopInputStream.readBigEndianInt(headerStream);
        HadoopLzopInputStream.readBigEndianInt(headerStream);
        int fileNameLength = headerStream.read();
        byte[] fileName = new byte[fileNameLength];
        this.readInput(fileName, 0, fileName.length);
        int headerChecksumValue = HadoopLzopInputStream.readBigEndianInt(in);
        Adler32 headerChecksum = new Adler32();
        headerChecksum.update(header, 0, header.length);
        headerChecksum.update(fileName, 0, fileName.length);
        if (headerChecksumValue != (int)headerChecksum.getValue()) {
            throw new IOException("Invalid header checksum");
        }
    }

    public int read() throws IOException {
        if (this.finished) {
            return -1;
        }
        while (this.uncompressedOffset >= this.uncompressedLength) {
            int compressedLength = this.bufferCompressedData();
            if (this.finished) {
                return -1;
            }
            this.decompress(compressedLength, this.uncompressedChunk, 0, this.uncompressedChunk.length);
        }
        return this.uncompressedChunk[this.uncompressedOffset++] & 0xFF;
    }

    public int read(byte[] output, int offset, int length) throws IOException {
        if (this.finished) {
            return -1;
        }
        while (this.uncompressedOffset >= this.uncompressedLength) {
            int compressedLength = this.bufferCompressedData();
            if (this.finished) {
                return -1;
            }
            if (length >= this.uncompressedLength) {
                this.decompress(compressedLength, output, offset, length);
                this.uncompressedOffset = this.uncompressedLength;
                return this.uncompressedLength;
            }
            this.decompress(compressedLength, this.uncompressedChunk, 0, this.uncompressedChunk.length);
        }
        int size = Math.min(length, this.uncompressedLength - this.uncompressedOffset);
        System.arraycopy(this.uncompressedChunk, this.uncompressedOffset, output, offset, size);
        this.uncompressedOffset += size;
        return size;
    }

    public void resetState() throws IOException {
        this.uncompressedLength = 0;
        this.uncompressedOffset = 0;
        this.finished = false;
    }

    private int bufferCompressedData() throws IOException {
        this.uncompressedOffset = 0;
        this.uncompressedLength = HadoopLzopInputStream.readBigEndianInt(this.in);
        if (this.uncompressedLength == -1) {
            throw new EOFException("encountered EOF while reading block data");
        }
        if (this.uncompressedLength == 0) {
            this.finished = true;
            return -1;
        }
        int compressedLength = HadoopLzopInputStream.readBigEndianInt(this.in);
        if (compressedLength == -1) {
            throw new EOFException("encountered EOF while reading block data");
        }
        return compressedLength;
    }

    private void decompress(int compressedLength, byte[] output, int outputOffset, int outputLength) throws IOException {
        if (this.uncompressedLength == compressedLength) {
            this.readInput(output, outputOffset, compressedLength);
        } else {
            if (this.compressed.length < compressedLength) {
                this.compressed = new byte[compressedLength + 8];
            }
            this.readInput(this.compressed, 0, compressedLength);
            int actualUncompressedLength = this.decompressor.decompress(this.compressed, 0, compressedLength, output, outputOffset, outputLength);
            if (actualUncompressedLength != this.uncompressedLength) {
                throw new IOException("Decompressor did not decompress the entire block");
            }
        }
    }

    private void readInput(byte[] buffer, int offset, int length) throws IOException {
        while (length > 0) {
            int size = this.in.read(buffer, offset, length);
            if (size == -1) {
                throw new EOFException("encountered EOF while reading block data");
            }
            offset += size;
            length -= size;
        }
    }

    private static int readBigEndianShort(InputStream in) throws IOException {
        int b1 = in.read();
        if (b1 < 0) {
            return -1;
        }
        int b2 = in.read();
        if (b2 < 0) {
            throw new IOException("Stream is truncated");
        }
        return (b1 << 8) + b2;
    }

    private static int readBigEndianInt(InputStream in) throws IOException {
        int b4;
        int b3;
        int b1 = in.read();
        if (b1 < 0) {
            return -1;
        }
        int b2 = in.read();
        if ((b2 | (b3 = in.read()) | (b4 = in.read())) < 0) {
            throw new IOException("Stream is truncated");
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }
}

