/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.avro.data;

import org.apache.iceberg.shaded.org.apache.avro.Conversion;
import org.apache.iceberg.shaded.org.apache.avro.LogicalType;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class TimeConversions {

    public static class LossyTimestampMicrosConversion
    extends TimestampMicrosConversion {
        @Override
        public Long toLong(DateTime timestamp, Schema schema, LogicalType type) {
            return 1000L * timestamp.getMillis();
        }
    }

    public static class TimestampMicrosConversion
    extends Conversion<DateTime> {
        @Override
        public Class<DateTime> getConvertedType() {
            return DateTime.class;
        }

        @Override
        public String getLogicalTypeName() {
            return "timestamp-micros";
        }

        @Override
        public DateTime fromLong(Long microsFromEpoch, Schema schema, LogicalType type) {
            return new DateTime(microsFromEpoch / 1000L, DateTimeZone.UTC);
        }
    }

    public static class TimestampConversion
    extends Conversion<DateTime> {
        @Override
        public Class<DateTime> getConvertedType() {
            return DateTime.class;
        }

        @Override
        public String getLogicalTypeName() {
            return "timestamp-millis";
        }

        @Override
        public DateTime fromLong(Long millisFromEpoch, Schema schema, LogicalType type) {
            return new DateTime((Object)millisFromEpoch, DateTimeZone.UTC);
        }

        @Override
        public Long toLong(DateTime timestamp, Schema schema, LogicalType type) {
            return timestamp.getMillis();
        }
    }

    public static class LossyTimeMicrosConversion
    extends TimeMicrosConversion {
        @Override
        public Long toLong(LocalTime time, Schema schema, LogicalType type) {
            return 1000L * (long)time.millisOfDay().get();
        }
    }

    public static class TimeMicrosConversion
    extends Conversion<LocalTime> {
        @Override
        public Class<LocalTime> getConvertedType() {
            return LocalTime.class;
        }

        @Override
        public String getLogicalTypeName() {
            return "time-micros";
        }

        @Override
        public LocalTime fromLong(Long microsFromMidnight, Schema schema, LogicalType type) {
            return LocalTime.fromMillisOfDay((long)(microsFromMidnight / 1000L));
        }
    }

    public static class TimeConversion
    extends Conversion<LocalTime> {
        @Override
        public Class<LocalTime> getConvertedType() {
            return LocalTime.class;
        }

        @Override
        public String getLogicalTypeName() {
            return "time-millis";
        }

        @Override
        public LocalTime fromInt(Integer millisFromMidnight, Schema schema, LogicalType type) {
            return LocalTime.fromMillisOfDay((long)millisFromMidnight.intValue());
        }

        @Override
        public Integer toInt(LocalTime time, Schema schema, LogicalType type) {
            return time.millisOfDay().get();
        }
    }

    public static class DateConversion
    extends Conversion<LocalDate> {
        private static final LocalDate EPOCH_DATE = new LocalDate(1970, 1, 1);

        @Override
        public Class<LocalDate> getConvertedType() {
            return LocalDate.class;
        }

        @Override
        public String getLogicalTypeName() {
            return "date";
        }

        @Override
        public LocalDate fromInt(Integer daysFromEpoch, Schema schema, LogicalType type) {
            return EPOCH_DATE.plusDays(daysFromEpoch.intValue());
        }

        @Override
        public Integer toInt(LocalDate date, Schema schema, LogicalType type) {
            return Days.daysBetween((ReadablePartial)EPOCH_DATE, (ReadablePartial)date).getDays();
        }
    }
}

