/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.impl.writer;

import java.io.IOException;
import org.apache.iceberg.shaded.org.apache.orc.OrcProto;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.apache.iceberg.shaded.org.apache.orc.impl.PositionRecorder;
import org.apache.iceberg.shaded.org.apache.orc.impl.PositionedOutputStream;
import org.apache.iceberg.shaded.org.apache.orc.impl.SerializationUtils;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.TreeWriterBase;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.WriterContext;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.util.JavaDataModel;

public class FloatTreeWriter
extends TreeWriterBase {
    private final PositionedOutputStream stream;
    private final SerializationUtils utils;

    public FloatTreeWriter(int columnId, TypeDescription schema, WriterContext writer, boolean nullable) throws IOException {
        super(columnId, schema, writer, nullable);
        this.stream = writer.createStream(this.id, OrcProto.Stream.Kind.DATA);
        this.utils = new SerializationUtils();
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        block6: {
            DoubleColumnVector vec;
            block5: {
                super.writeBatch(vector, offset, length);
                vec = (DoubleColumnVector)vector;
                if (!vector.isRepeating) break block5;
                if (!vector.noNulls && vector.isNull[0]) break block6;
                float value = (float)vec.vector[0];
                this.indexStatistics.updateDouble(value);
                if (this.createBloomFilter) {
                    if (this.bloomFilter != null) {
                        this.bloomFilter.addDouble(value);
                    }
                    this.bloomFilterUtf8.addDouble(value);
                }
                for (int i = 0; i < length; ++i) {
                    this.utils.writeFloat(this.stream, value);
                }
                break block6;
            }
            for (int i = 0; i < length; ++i) {
                if (!vec.noNulls && vec.isNull[i + offset]) continue;
                float value = (float)vec.vector[i + offset];
                this.utils.writeFloat(this.stream, value);
                this.indexStatistics.updateDouble(value);
                if (!this.createBloomFilter) continue;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addDouble(value);
                }
                this.bloomFilterUtf8.addDouble(value);
            }
        }
    }

    @Override
    public void writeStripe(OrcProto.StripeFooter.Builder builder, OrcProto.StripeStatistics.Builder stats, int requiredIndexEntries) throws IOException {
        super.writeStripe(builder, stats, requiredIndexEntries);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    void recordPosition(PositionRecorder recorder) throws IOException {
        super.recordPosition(recorder);
        this.stream.getPosition(recorder);
    }

    @Override
    public long estimateMemory() {
        return super.estimateMemory() + this.stream.getBufferSize();
    }

    @Override
    public long getRawDataSize() {
        long num = this.fileStatistics.getNumberOfValues();
        return num * (long)JavaDataModel.get().primitive1();
    }

    @Override
    public void flushStreams() throws IOException {
        super.flushStreams();
        this.stream.flush();
    }
}

