/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.impl.writer;

import java.io.IOException;
import org.apache.iceberg.shaded.org.apache.orc.OrcFile;
import org.apache.iceberg.shaded.org.apache.orc.OrcProto;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.BinaryTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.BooleanTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.ByteTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.CharTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.DateTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.Decimal64TreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.DecimalTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.DoubleTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.FloatTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.IntegerTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.ListTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.MapTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.StringTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.StructTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.TimestampTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.UnionTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.VarcharTreeWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.WriterContext;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

public interface TreeWriter {
    public long estimateMemory();

    public long getRawDataSize();

    public void writeRootBatch(VectorizedRowBatch var1, int var2, int var3) throws IOException;

    public void writeBatch(ColumnVector var1, int var2, int var3) throws IOException;

    public void createRowIndexEntry() throws IOException;

    public void flushStreams() throws IOException;

    public void writeStripe(OrcProto.StripeFooter.Builder var1, OrcProto.StripeStatistics.Builder var2, int var3) throws IOException;

    public void updateFileStatistics(OrcProto.StripeStatistics var1);

    public void writeFileStatistics(OrcProto.Footer.Builder var1);

    public static class Factory {
        public static TreeWriter create(TypeDescription schema, WriterContext streamFactory, boolean nullable) throws IOException {
            OrcFile.Version version = streamFactory.getVersion();
            switch (schema.getCategory()) {
                case BOOLEAN: {
                    return new BooleanTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case BYTE: {
                    return new ByteTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case SHORT: 
                case INT: 
                case LONG: {
                    return new IntegerTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case FLOAT: {
                    return new FloatTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case DOUBLE: {
                    return new DoubleTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case STRING: {
                    return new StringTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case CHAR: {
                    return new CharTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case VARCHAR: {
                    return new VarcharTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case BINARY: {
                    return new BinaryTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case TIMESTAMP: {
                    return new TimestampTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case DATE: {
                    return new DateTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case DECIMAL: {
                    if (version == OrcFile.Version.UNSTABLE_PRE_2_0 && schema.getPrecision() <= 18) {
                        return new Decimal64TreeWriter(schema.getId(), schema, streamFactory, nullable);
                    }
                    return new DecimalTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case STRUCT: {
                    return new StructTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case MAP: {
                    return new MapTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case LIST: {
                    return new ListTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
                case UNION: {
                    return new UnionTreeWriter(schema.getId(), schema, streamFactory, nullable);
                }
            }
            throw new IllegalArgumentException("Bad category: " + (Object)((Object)schema.getCategory()));
        }
    }
}

