/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.storage.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.shaded.org.apache.orc.storage.common.ValidReaderWriteIdList;
import org.apache.iceberg.shaded.org.apache.orc.storage.common.ValidWriteIdList;

public class ValidTxnWriteIdList {
    public static final String VALID_TABLES_WRITEIDS_KEY = "hive.txn.tables.valid.writeids";
    private Long txnId;
    private Map<String, ValidWriteIdList> tablesValidWriteIdList = new HashMap<String, ValidWriteIdList>();

    public ValidTxnWriteIdList(Long txnId) {
        this.txnId = txnId;
    }

    public ValidTxnWriteIdList(String value) {
        this.readFromString(value);
    }

    public String toString() {
        return this.writeToString();
    }

    public void addTableValidWriteIdList(ValidWriteIdList validWriteIds) {
        this.tablesValidWriteIdList.put(validWriteIds.getTableName(), validWriteIds);
    }

    public ValidWriteIdList getTableValidWriteIdList(String fullTableName) {
        if (this.tablesValidWriteIdList.containsKey(fullTableName)) {
            return this.tablesValidWriteIdList.get(fullTableName);
        }
        return null;
    }

    private void readFromString(String src) {
        if (src == null || src.length() == 0) {
            return;
        }
        String[] tblWriteIdStrList = src.split("\\$");
        assert (tblWriteIdStrList.length >= 1);
        this.txnId = Long.parseLong(tblWriteIdStrList[0]);
        for (int index = 1; index < tblWriteIdStrList.length; ++index) {
            String tableStr = tblWriteIdStrList[index];
            ValidReaderWriteIdList validWriteIdList = new ValidReaderWriteIdList(tableStr);
            this.addTableValidWriteIdList(validWriteIdList);
        }
    }

    private String writeToString() {
        StringBuilder buf = new StringBuilder(this.txnId.toString());
        int index = 0;
        for (Map.Entry<String, ValidWriteIdList> entry : this.tablesValidWriteIdList.entrySet()) {
            if (index < this.tablesValidWriteIdList.size()) {
                buf.append('$');
            }
            buf.append(entry.getValue().writeToString());
            ++index;
        }
        return buf.toString();
    }
}

