/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.storage.common.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.iceberg.shaded.org.apache.orc.storage.common.util.Murmur3;

public class BloomKFilter {
    private final byte[] BYTE_ARRAY_4 = new byte[4];
    private final byte[] BYTE_ARRAY_8 = new byte[8];
    public static final float DEFAULT_FPP = 0.05f;
    private static final int DEFAULT_BLOCK_SIZE = 8;
    private static final int DEFAULT_BLOCK_SIZE_BITS = (int)(Math.log(8.0) / Math.log(2.0));
    private static final int DEFAULT_BLOCK_OFFSET_MASK = 7;
    private static final int DEFAULT_BIT_OFFSET_MASK = 63;
    private final long[] masks = new long[8];
    private final BitSet bitSet;
    private final int m;
    private final int k;
    private final int totalBlockCount;
    public static final int START_OF_SERIALIZED_LONGS = 5;

    static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public BloomKFilter(long maxNumEntries) {
        BloomKFilter.checkArgument(maxNumEntries > 0L, "expectedEntries should be > 0");
        long numBits = BloomKFilter.optimalNumOfBits(maxNumEntries, 0.05f);
        this.k = BloomKFilter.optimalNumOfHashFunctions(maxNumEntries, numBits);
        int nLongs = (int)Math.ceil((double)numBits / 64.0);
        int padLongs = 8 - nLongs % 8;
        this.m = (nLongs + padLongs) * 64;
        this.bitSet = new BitSet(this.m);
        BloomKFilter.checkArgument(this.bitSet.data.length % 8 == 0, "bitSet has to be block aligned");
        this.totalBlockCount = this.bitSet.data.length / 8;
    }

    public BloomKFilter(long[] bits, int numFuncs) {
        this.bitSet = new BitSet(bits);
        this.m = bits.length * 64;
        this.k = numFuncs;
        BloomKFilter.checkArgument(this.bitSet.data.length % 8 == 0, "bitSet has to be block aligned");
        this.totalBlockCount = this.bitSet.data.length / 8;
    }

    static int optimalNumOfHashFunctions(long n, long m3) {
        return Math.max(1, (int)Math.round((double)m3 / (double)n * Math.log(2.0)));
    }

    static long optimalNumOfBits(long n, double p) {
        return (long)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    public void add(byte[] val) {
        this.addBytes(val);
    }

    public void addBytes(byte[] val, int offset, int length) {
        long hash64 = val == null ? 2862933555777941757L : Murmur3.hash64(val, offset, length);
        this.addHash(hash64);
    }

    public void addBytes(byte[] val) {
        this.addBytes(val, 0, val.length);
    }

    private void addHash(long hash64) {
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        int firstHash = hash1 + hash2;
        if (firstHash < 0) {
            firstHash ^= 0xFFFFFFFF;
        }
        int blockIdx = firstHash % this.totalBlockCount;
        int blockBaseOffset = blockIdx << DEFAULT_BLOCK_SIZE_BITS;
        for (int i = 1; i <= this.k; ++i) {
            int combinedHash = hash1 + (i + 1) * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            int absOffset = blockBaseOffset + (combinedHash & 7);
            int bitPos = combinedHash >>> DEFAULT_BLOCK_SIZE_BITS & 0x3F;
            long[] lArray = this.bitSet.data;
            int n = absOffset;
            lArray[n] = lArray[n] | 1L << bitPos;
        }
    }

    public void addString(String val) {
        this.addBytes(val.getBytes());
    }

    public void addByte(byte val) {
        this.addBytes(new byte[]{val});
    }

    public void addInt(int val) {
        this.addBytes(this.intToByteArrayLE(val));
    }

    public void addLong(long val) {
        this.addBytes(this.longToByteArrayLE(val));
    }

    public void addFloat(float val) {
        this.addInt(Float.floatToIntBits(val));
    }

    public void addDouble(double val) {
        this.addLong(Double.doubleToLongBits(val));
    }

    public boolean test(byte[] val) {
        return this.testBytes(val);
    }

    public boolean testBytes(byte[] val) {
        return this.testBytes(val, 0, val.length);
    }

    public boolean testBytes(byte[] val, int offset, int length) {
        long hash64 = val == null ? 2862933555777941757L : Murmur3.hash64(val, offset, length);
        return this.testHash(hash64);
    }

    private boolean testHash(long hash64) {
        int hash1 = (int)hash64;
        int hash2 = (int)(hash64 >>> 32);
        int firstHash = hash1 + hash2;
        if (firstHash < 0) {
            firstHash ^= 0xFFFFFFFF;
        }
        int blockIdx = firstHash % this.totalBlockCount;
        int blockBaseOffset = blockIdx << DEFAULT_BLOCK_SIZE_BITS;
        for (int i = 1; i <= this.k; ++i) {
            int combinedHash = hash1 + (i + 1) * hash2;
            if (combinedHash < 0) {
                combinedHash ^= 0xFFFFFFFF;
            }
            int wordOffset = combinedHash & 7;
            int bitPos = combinedHash >>> DEFAULT_BLOCK_SIZE_BITS & 0x3F;
            int n = wordOffset;
            this.masks[n] = this.masks[n] | 1L << bitPos;
        }
        long expected = 0L;
        for (int i = 0; i < 8; ++i) {
            long mask = this.masks[i];
            expected |= this.bitSet.data[blockBaseOffset + i] & mask ^ mask;
        }
        Arrays.fill(this.masks, 0L);
        return expected == 0L;
    }

    public boolean testString(String val) {
        return this.testBytes(val.getBytes());
    }

    public boolean testByte(byte val) {
        return this.testBytes(new byte[]{val});
    }

    public boolean testInt(int val) {
        return this.testBytes(this.intToByteArrayLE(val));
    }

    public boolean testLong(long val) {
        return this.testBytes(this.longToByteArrayLE(val));
    }

    public boolean testFloat(float val) {
        return this.testInt(Float.floatToIntBits(val));
    }

    public boolean testDouble(double val) {
        return this.testLong(Double.doubleToLongBits(val));
    }

    private byte[] intToByteArrayLE(int val) {
        this.BYTE_ARRAY_4[0] = (byte)(val >> 0);
        this.BYTE_ARRAY_4[1] = (byte)(val >> 8);
        this.BYTE_ARRAY_4[2] = (byte)(val >> 16);
        this.BYTE_ARRAY_4[3] = (byte)(val >> 24);
        return this.BYTE_ARRAY_4;
    }

    private byte[] longToByteArrayLE(long val) {
        this.BYTE_ARRAY_8[0] = (byte)(val >> 0);
        this.BYTE_ARRAY_8[1] = (byte)(val >> 8);
        this.BYTE_ARRAY_8[2] = (byte)(val >> 16);
        this.BYTE_ARRAY_8[3] = (byte)(val >> 24);
        this.BYTE_ARRAY_8[4] = (byte)(val >> 32);
        this.BYTE_ARRAY_8[5] = (byte)(val >> 40);
        this.BYTE_ARRAY_8[6] = (byte)(val >> 48);
        this.BYTE_ARRAY_8[7] = (byte)(val >> 56);
        return this.BYTE_ARRAY_8;
    }

    public long sizeInBytes() {
        return this.getBitSize() / 8;
    }

    public int getBitSize() {
        return this.bitSet.getData().length * 64;
    }

    public int getNumHashFunctions() {
        return this.k;
    }

    public int getNumBits() {
        return this.m;
    }

    public long[] getBitSet() {
        return this.bitSet.getData();
    }

    public String toString() {
        return "m: " + this.m + " k: " + this.k;
    }

    public void merge(BloomKFilter that) {
        if (this == that || this.m != that.m || this.k != that.k) {
            throw new IllegalArgumentException("BloomKFilters are not compatible for merging. this - " + this.toString() + " that - " + that.toString());
        }
        this.bitSet.putAll(that.bitSet);
    }

    public void reset() {
        this.bitSet.clear();
    }

    public static void serialize(OutputStream out, BloomKFilter bloomFilter) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(out);
        dataOutputStream.writeByte(bloomFilter.k);
        dataOutputStream.writeInt(bloomFilter.getBitSet().length);
        for (long value : bloomFilter.getBitSet()) {
            dataOutputStream.writeLong(value);
        }
    }

    public static BloomKFilter deserialize(InputStream in) throws IOException {
        if (in == null) {
            throw new IOException("Input stream is null");
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(in);
            byte numHashFunc = dataInputStream.readByte();
            int bitsetArrayLen = dataInputStream.readInt();
            long[] data = new long[bitsetArrayLen];
            for (int i = 0; i < bitsetArrayLen; ++i) {
                data[i] = dataInputStream.readLong();
            }
            return new BloomKFilter(data, numHashFunc);
        }
        catch (RuntimeException e) {
            IOException io = new IOException("Unable to deserialize BloomKFilter");
            io.initCause(e);
            throw io;
        }
    }

    public static void mergeBloomFilterBytes(byte[] bf1Bytes, int bf1Start, int bf1Length, byte[] bf2Bytes, int bf2Start, int bf2Length) {
        int idx;
        if (bf1Length != bf2Length) {
            throw new IllegalArgumentException("bf1Length " + bf1Length + " does not match bf2Length " + bf2Length);
        }
        for (idx = 0; idx < 5; ++idx) {
            if (bf1Bytes[bf1Start + idx] == bf2Bytes[bf2Start + idx]) continue;
            throw new IllegalArgumentException("bf1 NumHashFunctions/NumBits does not match bf2");
        }
        for (idx = 5; idx < bf1Length; ++idx) {
            int n = bf1Start + idx;
            bf1Bytes[n] = (byte)(bf1Bytes[n] | bf2Bytes[bf2Start + idx]);
        }
    }

    public static class BitSet {
        private final long[] data;

        public BitSet(long bits) {
            this(new long[(int)Math.ceil((double)bits / 64.0)]);
        }

        public BitSet(long[] data) {
            assert (data.length > 0) : "data length is zero!";
            this.data = data;
        }

        public void set(int index) {
            int n = index >>> 6;
            this.data[n] = this.data[n] | 1L << index;
        }

        public boolean get(int index) {
            return (this.data[index >>> 6] & 1L << index) != 0L;
        }

        public int bitSize() {
            return this.data.length * 64;
        }

        public long[] getData() {
            return this.data;
        }

        public void putAll(BitSet array) {
            assert (this.data.length == array.data.length) : "BitArrays must be of equal length (" + this.data.length + "!= " + array.data.length + ")";
            for (int i = 0; i < this.data.length; ++i) {
                int n = i;
                this.data[n] = this.data[n] | array.data[i];
            }
        }

        public void clear() {
            Arrays.fill(this.data, 0L);
        }
    }
}

