/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.ListColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.MapColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.UnionColumnVector;

public class VectorizedRowBatch
implements Writable {
    public int numCols;
    public ColumnVector[] cols;
    public int size;
    public int[] selected;
    public int[] projectedColumns;
    public int projectionSize;
    private int dataColumnCount;
    private int partitionColumnCount;
    public boolean selectedInUse;
    public boolean endOfFile;
    public static final int DEFAULT_SIZE = 1024;
    public static final int DEFAULT_BYTES = 0x2000000;

    public VectorizedRowBatch(int numCols) {
        this(numCols, 1024);
    }

    public VectorizedRowBatch(int numCols, int size) {
        this.numCols = numCols;
        this.size = size;
        this.selected = new int[size];
        this.selectedInUse = false;
        this.cols = new ColumnVector[numCols];
        this.projectedColumns = new int[numCols];
        this.projectionSize = numCols;
        for (int i = 0; i < numCols; ++i) {
            this.projectedColumns[i] = i;
        }
        this.dataColumnCount = -1;
        this.partitionColumnCount = -1;
    }

    public void setPartitionInfo(int dataColumnCount, int partitionColumnCount) {
        this.dataColumnCount = dataColumnCount;
        this.partitionColumnCount = partitionColumnCount;
    }

    public int getDataColumnCount() {
        return this.dataColumnCount;
    }

    public int getPartitionColumnCount() {
        return this.partitionColumnCount;
    }

    public int getMaxSize() {
        return this.selected.length;
    }

    public long count() {
        return this.size;
    }

    private static String toUTF8(Object o) {
        if (o == null || o instanceof NullWritable) {
            return "\\N";
        }
        return o.toString();
    }

    public String stringifyColumn(int columnNum) {
        if (this.size == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append("columnNum ");
        b.append(columnNum);
        b.append(", size ");
        b.append(this.size);
        b.append(", selectedInUse ");
        b.append(this.selectedInUse);
        ColumnVector colVector = this.cols[columnNum];
        b.append(", noNulls ");
        b.append(colVector.noNulls);
        b.append(", isRepeating ");
        b.append(colVector.isRepeating);
        b.append('\n');
        boolean noNulls = colVector.noNulls;
        boolean[] isNull = colVector.isNull;
        if (colVector.isRepeating) {
            boolean hasRepeatedValue = noNulls || !isNull[0];
            for (int i = 0; i < this.size; ++i) {
                if (hasRepeatedValue) {
                    colVector.stringifyValue(b, 0);
                } else {
                    b.append("NULL");
                }
                b.append('\n');
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                int batchIndex;
                int n = batchIndex = this.selectedInUse ? this.selected[i] : i;
                if (noNulls || !isNull[batchIndex]) {
                    colVector.stringifyValue(b, batchIndex);
                } else {
                    b.append("NULL");
                }
                b.append('\n');
            }
        }
        return b.toString();
    }

    public String stringify(String prefix) {
        if (this.size == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(prefix);
        b.append("Column vector types: ");
        for (int k = 0; k < this.projectionSize; ++k) {
            int projIndex = this.projectedColumns[k];
            ColumnVector cv = this.cols[projIndex];
            if (k > 0) {
                b.append(", ");
            }
            b.append(projIndex);
            b.append(":");
            String colVectorType = null;
            colVectorType = cv instanceof LongColumnVector ? "LONG" : (cv instanceof DoubleColumnVector ? "DOUBLE" : (cv instanceof BytesColumnVector ? "BYTES" : (cv instanceof DecimalColumnVector ? "DECIMAL" : (cv instanceof TimestampColumnVector ? "TIMESTAMP" : (cv instanceof IntervalDayTimeColumnVector ? "INTERVAL_DAY_TIME" : (cv instanceof ListColumnVector ? "LIST" : (cv instanceof MapColumnVector ? "MAP" : (cv instanceof StructColumnVector ? "STRUCT" : (cv instanceof UnionColumnVector ? "UNION" : "Unknown")))))))));
            b.append(colVectorType);
        }
        b.append('\n');
        if (this.selectedInUse) {
            for (int j = 0; j < this.size; ++j) {
                int i = this.selected[j];
                b.append('[');
                for (int k = 0; k < this.projectionSize; ++k) {
                    int projIndex = this.projectedColumns[k];
                    ColumnVector cv = this.cols[projIndex];
                    if (k > 0) {
                        b.append(", ");
                    }
                    if (cv == null) continue;
                    try {
                        cv.stringifyValue(b, i);
                        continue;
                    }
                    catch (Exception ex) {
                        b.append("<invalid>");
                    }
                }
                b.append(']');
                if (j >= this.size - 1) continue;
                b.append('\n');
                b.append(prefix);
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                b.append('[');
                for (int k = 0; k < this.projectionSize; ++k) {
                    int projIndex = this.projectedColumns[k];
                    ColumnVector cv = this.cols[projIndex];
                    if (k > 0) {
                        b.append(", ");
                    }
                    if (cv == null) continue;
                    try {
                        cv.stringifyValue(b, i);
                        continue;
                    }
                    catch (Exception ex) {
                        b.append("<invalid>");
                    }
                }
                b.append(']');
                if (i >= this.size - 1) continue;
                b.append('\n');
                b.append(prefix);
            }
        }
        return b.toString();
    }

    public String toString() {
        return this.stringify("");
    }

    public void readFields(DataInput arg0) throws IOException {
        throw new UnsupportedOperationException("Do you really need me?");
    }

    public void write(DataOutput arg0) throws IOException {
        throw new UnsupportedOperationException("Don't call me");
    }

    public void reset() {
        this.selectedInUse = false;
        this.size = 0;
        this.endOfFile = false;
        for (ColumnVector vc : this.cols) {
            if (vc == null) continue;
            vc.reset();
            vc.init();
        }
    }

    public void ensureSize(int rows) {
        for (int i = 0; i < this.cols.length; ++i) {
            this.cols[i].ensureSize(rows, false);
        }
    }
}

