/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.bytes;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iceberg.shaded.org.apache.parquet.bytes.ByteBufferInputStream;

class MultiBufferInputStream
extends ByteBufferInputStream {
    private static final ByteBuffer EMPTY = ByteBuffer.allocate(0);
    private final List<ByteBuffer> buffers;
    private final long length;
    private Iterator<ByteBuffer> iterator;
    private ByteBuffer current = EMPTY;
    private long position = 0L;
    private long mark = -1L;
    private long markLimit = 0L;
    private List<ByteBuffer> markBuffers = new ArrayList<ByteBuffer>();

    MultiBufferInputStream(List<ByteBuffer> buffers) {
        this.buffers = buffers;
        long totalLen = 0L;
        for (ByteBuffer buffer : buffers) {
            totalLen += (long)buffer.remaining();
        }
        this.length = totalLen;
        this.iterator = buffers.iterator();
        this.nextBuffer();
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (this.current == null) {
            return -1L;
        }
        long bytesSkipped = 0L;
        while (bytesSkipped < n) {
            if (this.current.remaining() > 0) {
                long bytesToSkip = Math.min(n - bytesSkipped, (long)this.current.remaining());
                this.current.position(this.current.position() + (int)bytesToSkip);
                bytesSkipped += bytesToSkip;
                this.position += bytesToSkip;
                continue;
            }
            if (this.nextBuffer()) continue;
            return bytesSkipped > 0L ? bytesSkipped : -1L;
        }
        return bytesSkipped;
    }

    @Override
    public int read(ByteBuffer out) {
        int len = out.remaining();
        if (len <= 0) {
            return 0;
        }
        if (this.current == null) {
            return -1;
        }
        int bytesCopied = 0;
        while (bytesCopied < len) {
            if (this.current.remaining() > 0) {
                ByteBuffer copyBuffer;
                int bytesToCopy;
                if (this.current.remaining() <= out.remaining()) {
                    bytesToCopy = this.current.remaining();
                    copyBuffer = this.current;
                } else {
                    bytesToCopy = out.remaining();
                    copyBuffer = this.current.duplicate();
                    copyBuffer.limit(copyBuffer.position() + bytesToCopy);
                    this.current.position(copyBuffer.position() + bytesToCopy);
                }
                out.put(copyBuffer);
                bytesCopied += bytesToCopy;
                this.position += (long)bytesToCopy;
                continue;
            }
            if (this.nextBuffer()) continue;
            return bytesCopied > 0 ? bytesCopied : -1;
        }
        return bytesCopied;
    }

    @Override
    public ByteBuffer slice(int length) throws EOFException {
        ByteBuffer slice;
        if (length <= 0) {
            return EMPTY;
        }
        if (this.current == null) {
            throw new EOFException();
        }
        if (length > this.current.remaining()) {
            slice = ByteBuffer.allocate(length);
            int bytesCopied = this.read(slice);
            slice.flip();
            if (bytesCopied < length) {
                throw new EOFException();
            }
        } else {
            slice = this.current.duplicate();
            slice.limit(slice.position() + length);
            this.current.position(slice.position() + length);
            this.position += (long)length;
        }
        return slice;
    }

    @Override
    public List<ByteBuffer> sliceBuffers(long len) throws EOFException {
        if (len <= 0L) {
            return Collections.emptyList();
        }
        if (this.current == null) {
            throw new EOFException();
        }
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        long bytesAccumulated = 0L;
        while (bytesAccumulated < len) {
            if (this.current.remaining() > 0) {
                int bufLen = (int)Math.min(len - bytesAccumulated, (long)this.current.remaining());
                ByteBuffer slice = this.current.duplicate();
                slice.limit(slice.position() + bufLen);
                buffers.add(slice);
                bytesAccumulated += (long)bufLen;
                this.current.position(this.current.position() + bufLen);
                this.position += (long)bufLen;
                continue;
            }
            if (this.nextBuffer()) continue;
            throw new EOFException();
        }
        return buffers;
    }

    @Override
    public List<ByteBuffer> remainingBuffers() {
        if (this.position >= this.length) {
            return Collections.emptyList();
        }
        try {
            return this.sliceBuffers(this.length - this.position);
        }
        catch (EOFException e) {
            throw new RuntimeException("[Parquet bug] Stream is bad: incorrect bytes remaining " + (this.length - this.position));
        }
    }

    @Override
    public int read(byte[] bytes, int off, int len) {
        if (len <= 0) {
            if (len < 0) {
                throw new IndexOutOfBoundsException("Read length must be greater than 0: " + len);
            }
            return 0;
        }
        if (this.current == null) {
            return -1;
        }
        int bytesRead = 0;
        while (bytesRead < len) {
            if (this.current.remaining() > 0) {
                int bytesToRead = Math.min(len - bytesRead, this.current.remaining());
                this.current.get(bytes, off + bytesRead, bytesToRead);
                bytesRead += bytesToRead;
                this.position += (long)bytesToRead;
                continue;
            }
            if (this.nextBuffer()) continue;
            return bytesRead > 0 ? bytesRead : -1;
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] bytes) {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read() throws IOException {
        if (this.current == null) {
            throw new EOFException();
        }
        do {
            if (this.current.remaining() <= 0) continue;
            ++this.position;
            return this.current.get() & 0xFF;
        } while (this.nextBuffer());
        throw new EOFException();
    }

    @Override
    public int available() {
        long remaining = this.length - this.position;
        if (remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remaining;
    }

    @Override
    public void mark(int readlimit) {
        if (this.mark >= 0L) {
            this.discardMark();
        }
        this.mark = this.position;
        this.markLimit = this.mark + (long)readlimit + 1L;
        if (this.current != null) {
            this.markBuffers.add(this.current.duplicate());
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.mark < 0L || this.position >= this.markLimit) {
            throw new IOException("No mark defined or has read past the previous mark limit");
        }
        this.position = this.mark;
        this.iterator = MultiBufferInputStream.concat(this.markBuffers.iterator(), this.iterator);
        this.discardMark();
        this.nextBuffer();
    }

    private void discardMark() {
        this.mark = -1L;
        this.markLimit = 0L;
        this.markBuffers = new ArrayList<ByteBuffer>();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    private boolean nextBuffer() {
        if (!this.iterator.hasNext()) {
            this.current = null;
            return false;
        }
        this.current = this.iterator.next().duplicate();
        if (this.mark >= 0L) {
            if (this.position < this.markLimit) {
                this.markBuffers.add(this.current.duplicate());
            } else {
                this.discardMark();
            }
        }
        return true;
    }

    private static <E> Iterator<E> concat(Iterator<E> first, Iterator<E> second) {
        return new ConcatIterator<E>(first, second);
    }

    private static class ConcatIterator<E>
    implements Iterator<E> {
        private final Iterator<E> first;
        private final Iterator<E> second;
        boolean useFirst = true;

        public ConcatIterator(Iterator<E> first, Iterator<E> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public boolean hasNext() {
            if (this.useFirst) {
                if (this.first.hasNext()) {
                    return true;
                }
                this.useFirst = false;
                return this.second.hasNext();
            }
            return this.second.hasNext();
        }

        @Override
        public E next() {
            if (this.useFirst && !this.first.hasNext()) {
                this.useFirst = false;
            }
            if (!this.useFirst && !this.second.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.useFirst) {
                return this.first.next();
            }
            return this.second.next();
        }

        @Override
        public void remove() {
            if (this.useFirst) {
                this.first.remove();
            }
            this.second.remove();
        }
    }
}

