/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.filter2.recordlevel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.shaded.org.apache.parquet.Preconditions;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.recordlevel.FilteringGroupConverter;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicateEvaluator;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicateResetter;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.iceberg.shaded.org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.GroupConverter;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.RecordMaterializer;

public class FilteringRecordMaterializer<T>
extends RecordMaterializer<T> {
    private final RecordMaterializer<T> delegate;
    private final FilteringGroupConverter rootConverter;
    private final IncrementallyUpdatedFilterPredicate filterPredicate;

    public FilteringRecordMaterializer(RecordMaterializer<T> delegate, List<PrimitiveColumnIO> columnIOs, Map<ColumnPath, List<IncrementallyUpdatedFilterPredicate.ValueInspector>> valueInspectorsByColumn, IncrementallyUpdatedFilterPredicate filterPredicate) {
        Preconditions.checkNotNull(columnIOs, "columnIOs");
        Preconditions.checkNotNull(valueInspectorsByColumn, "valueInspectorsByColumn");
        this.filterPredicate = Preconditions.checkNotNull(filterPredicate, "filterPredicate");
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        HashMap<List<Integer>, PrimitiveColumnIO> columnIOsByIndexFieldPath = new HashMap<List<Integer>, PrimitiveColumnIO>();
        for (PrimitiveColumnIO c : columnIOs) {
            columnIOsByIndexFieldPath.put(FilteringRecordMaterializer.getIndexFieldPathList(c), c);
        }
        this.rootConverter = new FilteringGroupConverter(delegate.getRootConverter(), Collections.emptyList(), valueInspectorsByColumn, columnIOsByIndexFieldPath);
    }

    public static List<Integer> getIndexFieldPathList(PrimitiveColumnIO c) {
        return FilteringRecordMaterializer.intArrayToList(c.getIndexFieldPath());
    }

    public static List<Integer> intArrayToList(int[] arr) {
        ArrayList<Integer> list = new ArrayList<Integer>(arr.length);
        for (int i : arr) {
            list.add(i);
        }
        return list;
    }

    @Override
    public T getCurrentRecord() {
        boolean keep = IncrementallyUpdatedFilterPredicateEvaluator.evaluate(this.filterPredicate);
        IncrementallyUpdatedFilterPredicateResetter.reset(this.filterPredicate);
        if (keep) {
            return this.delegate.getCurrentRecord();
        }
        return null;
    }

    @Override
    public void skipCurrentRecord() {
        this.delegate.skipCurrentRecord();
    }

    @Override
    public GroupConverter getRootConverter() {
        return this.rootConverter;
    }
}

