/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.schema;

import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveStringifier;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;

public enum OriginalType {
    MAP,
    LIST,
    UTF8(PrimitiveStringifier.UTF8_STRINGIFIER),
    MAP_KEY_VALUE,
    ENUM(PrimitiveStringifier.UTF8_STRINGIFIER),
    DECIMAL{

        @Override
        PrimitiveStringifier stringifier(PrimitiveType type) {
            return PrimitiveStringifier.createDecimalStringifier(type.getDecimalMetadata().getScale());
        }
    }
    ,
    DATE(PrimitiveStringifier.DATE_STRINGIFIER),
    TIME_MILLIS(PrimitiveStringifier.TIME_STRINGIFIER),
    TIME_MICROS(PrimitiveStringifier.TIME_STRINGIFIER),
    TIMESTAMP_MILLIS(PrimitiveStringifier.TIMESTAMP_MILLIS_STRINGIFIER),
    TIMESTAMP_MICROS(PrimitiveStringifier.TIMESTAMP_MICROS_STRINGIFIER),
    UINT_8(PrimitiveStringifier.UNSIGNED_STRINGIFIER),
    UINT_16(PrimitiveStringifier.UNSIGNED_STRINGIFIER),
    UINT_32(PrimitiveStringifier.UNSIGNED_STRINGIFIER),
    UINT_64(PrimitiveStringifier.UNSIGNED_STRINGIFIER),
    INT_8(PrimitiveStringifier.DEFAULT_STRINGIFIER),
    INT_16(PrimitiveStringifier.DEFAULT_STRINGIFIER),
    INT_32(PrimitiveStringifier.DEFAULT_STRINGIFIER),
    INT_64(PrimitiveStringifier.DEFAULT_STRINGIFIER),
    JSON(PrimitiveStringifier.UTF8_STRINGIFIER),
    BSON(PrimitiveStringifier.DEFAULT_STRINGIFIER),
    INTERVAL(PrimitiveStringifier.INTERVAL_STRINGIFIER);

    private final PrimitiveStringifier stringifier;

    PrimitiveStringifier stringifier(PrimitiveType type) {
        if (this.stringifier == null) {
            throw new UnsupportedOperationException("Stringifier is not supported for the original type: " + (Object)((Object)this));
        }
        return this.stringifier;
    }

    private OriginalType() {
        this((PrimitiveStringifier)null);
    }

    private OriginalType(PrimitiveStringifier stringifier) {
        this.stringifier = stringifier;
    }
}

